/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ContentDescriptor
extends Descriptor {
    private List<ContentItem> contentList = new ArrayList<ContentItem>();

    public ContentDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        for (int t = 0; t < this.descriptorLength; t += 2) {
            int cNibble1 = Utils.getInt(b, t + 2, 1, 240) >> 4;
            int cNnibble2 = Utils.getInt(b, t + 2, 1, 15);
            int user_byte = Utils.getInt(b, t + 3, 1, 255);
            ContentItem s = new ContentItem(cNibble1, cNnibble2, user_byte);
            this.contentList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (ContentItem contentItem : this.contentList) {
            buf.append(contentItem.toString());
        }
        return buf.toString();
    }

    public static String getContentNibbleLevel1String(int nibble1) {
        return switch (nibble1) {
            case 0 -> "undefined content";
            case 1 -> "Movie/Drama:";
            case 2 -> "News/Current affairs:";
            case 3 -> "Show/Game show:";
            case 4 -> "Sports:";
            case 5 -> "Children's/Youth programmes:";
            case 6 -> "Music/Ballet/Dance:";
            case 7 -> "Arts/Culture (without music):";
            case 8 -> "Social/Political issues/Economics:";
            case 9 -> "Education/Science/Factual topics:";
            case 10 -> "Leisure hobbies:";
            case 11 -> "Special characteristics:";
            case 12 -> "Adult:";
            case 15 -> "user defined";
            default -> "reserved for future use:";
        };
    }

    public static String getContentNibbleLevel2String(int nibble1, int nibble2) {
        return switch (nibble1) {
            case 0 -> "";
            case 1 -> {
                switch (nibble2) {
                    case 0: {
                        yield "movie/drama (general)";
                    }
                    case 1: {
                        yield "detective/thriller";
                    }
                    case 2: {
                        yield "adventure/western/war";
                    }
                    case 3: {
                        yield "science fiction/fantasy/horror";
                    }
                    case 4: {
                        yield "comedy";
                    }
                    case 5: {
                        yield "soap/melodrama/folkloric";
                    }
                    case 6: {
                        yield "romance";
                    }
                    case 7: {
                        yield "serious/classical/religious/historical movie/drama";
                    }
                    case 8: {
                        yield "adult movie/drama";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 2 -> {
                switch (nibble2) {
                    case 0: {
                        yield "news/current affairs (general)";
                    }
                    case 1: {
                        yield "news/weather report";
                    }
                    case 2: {
                        yield "news magazine";
                    }
                    case 3: {
                        yield "documentary";
                    }
                    case 4: {
                        yield "discussion/interview/debate";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 3 -> {
                switch (nibble2) {
                    case 0: {
                        yield "show/game show (general)";
                    }
                    case 1: {
                        yield "game show/quiz/contest";
                    }
                    case 2: {
                        yield "variety show";
                    }
                    case 3: {
                        yield "talk show";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 4 -> {
                switch (nibble2) {
                    case 0: {
                        yield "sports (general)";
                    }
                    case 1: {
                        yield "special events (Olympic Games, World Cup, etc.)";
                    }
                    case 2: {
                        yield "sports magazines";
                    }
                    case 3: {
                        yield "football/soccer";
                    }
                    case 4: {
                        yield "tennis/squash";
                    }
                    case 5: {
                        yield "team sports (excluding football)";
                    }
                    case 6: {
                        yield "athletics";
                    }
                    case 7: {
                        yield "motor sport";
                    }
                    case 8: {
                        yield "water sport";
                    }
                    case 9: {
                        yield "winter sports";
                    }
                    case 10: {
                        yield "equestrian";
                    }
                    case 11: {
                        yield "martial sports";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 5 -> {
                switch (nibble2) {
                    case 0: {
                        yield "children's/youth programmes (general)";
                    }
                    case 1: {
                        yield "pre-school children's programmes";
                    }
                    case 2: {
                        yield "entertainment programmes for 6 to14";
                    }
                    case 3: {
                        yield "entertainment programmes for 10 to 16";
                    }
                    case 4: {
                        yield "informational/educational/school programmes";
                    }
                    case 5: {
                        yield "cartoons/puppets";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 6 -> {
                switch (nibble2) {
                    case 0: {
                        yield "music/ballet/dance (general)";
                    }
                    case 1: {
                        yield "rock/pop";
                    }
                    case 2: {
                        yield "serious music/classical music";
                    }
                    case 3: {
                        yield "folk/traditional music";
                    }
                    case 4: {
                        yield "jazz";
                    }
                    case 5: {
                        yield "musical/opera";
                    }
                    case 6: {
                        yield "ballet";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 7 -> {
                switch (nibble2) {
                    case 0: {
                        yield "arts/culture (without music, general)";
                    }
                    case 1: {
                        yield "performing arts";
                    }
                    case 2: {
                        yield "fine arts";
                    }
                    case 3: {
                        yield "religion";
                    }
                    case 4: {
                        yield "popular culture/traditional arts";
                    }
                    case 5: {
                        yield "literature";
                    }
                    case 6: {
                        yield "film/cinema";
                    }
                    case 7: {
                        yield "experimental film/video";
                    }
                    case 8: {
                        yield "broadcasting/press";
                    }
                    case 9: {
                        yield "new media";
                    }
                    case 10: {
                        yield "arts/culture magazines";
                    }
                    case 11: {
                        yield "fashion";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 8 -> {
                switch (nibble2) {
                    case 0: {
                        yield "social/political issues/economics (general)";
                    }
                    case 1: {
                        yield "magazines/reports/documentary";
                    }
                    case 2: {
                        yield "economics/social advisory";
                    }
                    case 3: {
                        yield "remarkable people";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 9 -> {
                switch (nibble2) {
                    case 0: {
                        yield "education/science/factual topics (general)";
                    }
                    case 1: {
                        yield "nature/animals/environment";
                    }
                    case 2: {
                        yield "technology/natural sciences";
                    }
                    case 3: {
                        yield "medicine/physiology/psychology";
                    }
                    case 4: {
                        yield "foreign countries/expeditions";
                    }
                    case 5: {
                        yield "social/spiritual sciences";
                    }
                    case 6: {
                        yield "further education";
                    }
                    case 7: {
                        yield "languages";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 10 -> {
                switch (nibble2) {
                    case 0: {
                        yield "leisure hobbies (general)";
                    }
                    case 1: {
                        yield "tourism/travel";
                    }
                    case 2: {
                        yield "handicraft";
                    }
                    case 3: {
                        yield "motoring";
                    }
                    case 4: {
                        yield "fitness and health";
                    }
                    case 5: {
                        yield "cooking";
                    }
                    case 6: {
                        yield "advertisement/shopping";
                    }
                    case 7: {
                        yield "gardening";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 11 -> {
                switch (nibble2) {
                    case 0: {
                        yield "original language";
                    }
                    case 1: {
                        yield "black and white";
                    }
                    case 2: {
                        yield "unpublished";
                    }
                    case 3: {
                        yield "live broadcast";
                    }
                    case 4: {
                        yield "plano-stereoscopic";
                    }
                    case 5: {
                        yield "local or regional";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 12 -> {
                switch (nibble2) {
                    case 0: {
                        yield "adult (general)";
                    }
                    case 15: {
                        yield "user defined";
                    }
                }
                yield "reserved for future use";
            }
            case 15 -> "";
            default -> "reserved for future use";
        };
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.contentList, modus, "content_list");
        return t;
    }

    public List<ContentItem> getContentList() {
        return this.contentList;
    }

    public record ContentItem(int contentNibbleLevel1, int contentNibbleLevel2, int user_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("content type");
            s.add(new KVP("content_nibble_level_1", this.contentNibbleLevel1).setDescription(ContentDescriptor.getContentNibbleLevel1String(this.contentNibbleLevel1)));
            s.add(new KVP("content_nibble_level_2", this.contentNibbleLevel2).setDescription(ContentDescriptor.getContentNibbleLevel2String(this.contentNibbleLevel1, this.contentNibbleLevel2)));
            s.add(new KVP("user_byte", this.user_byte));
            return s;
        }
    }
}

