/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class Descriptor
implements TreeNode {
    private static final LookUpList metadata_application_format_list = new LookUpList.Builder().add(0, 15, "Reserved").add(16, "ISO 15706 (ISAN) encoded in its binary form").add(17, "ISO 15706-2 (V-ISAN) encoded in its binary form").add(18, 255, "Reserved").add(256, "metadata service contains TVA metadata as profiled according to DVB").add(257, "metadata contained conforms to DTG D-Book Record List.").add(258, 65534, "User defined").add(65535, "Defined by the metadata_application_format_identifier field").build();
    private static final LookUpList mpeg_carriage_flags_list = new LookUpList.Builder().add(0, "Carriage in the same transport stream where this metadata pointer descriptor is carried.").add(1, "Carriage in a different transport stream from where this metadata pointer descriptor is carried.").add(2, "Carriage in a program stream. This may or may not be the same program stream in which this metadata pointer descriptor is carried.").add(3, "may be used if there is no relevant metadata carried on the DVB network. In this case the metadata locator record shall be present").build();
    private static final LookUpList metadata_format_list = new LookUpList.Builder().add(0, 15, "Reserved").add(16, "ISO/IEC 15938-1 TeM").add(17, "ISO/IEC 15938-1 BiM").add(18, 62, "Reserved").add(63, "Defined by metadata application format").add(64, 239, "User Defined").add(240, "The encoding and encapsulation format as defined in clauses 9.3 and 9.4 of ETSI TS 102 323 V1.5.1").add(241, 247, "DVB Reserved").add(248, 254, "User Defined").add(255, "Defined by metadata_format_identifier field").build();
    public static final int PRIVATE_DATA_OFFSET = 2;
    protected final int descriptorTag;
    protected final int descriptorLength;
    protected final byte[] privateData;
    protected final TableSection parentTableSection;

    public Descriptor(byte[] b, TableSection parent) {
        this.privateData = b;
        this.descriptorTag = Byte.toUnsignedInt(b[0]);
        this.descriptorLength = Byte.toUnsignedInt(b[1]);
        this.parentTableSection = parent;
    }

    public Descriptor(byte[] b, int offset, TableSection parent) {
        this(b, parent);
    }

    public int getDescriptorLength() {
        return this.descriptorLength;
    }

    public int getDescriptorTag() {
        return this.descriptorTag;
    }

    public String getDescriptorname() {
        return Descriptor.getDescriptorname(this.descriptorTag, this.parentTableSection);
    }

    public static String getDescriptorname(int tag, TableSection tableSection) {
        return switch (tag) {
            case 0 -> "Reserved";
            case 1 -> "Reserved";
            case 2 -> "video_stream_descriptor";
            case 3 -> "audio_stream_descriptor";
            case 4 -> "hierarchy_descriptor";
            case 5 -> "registration_descriptor";
            case 6 -> "data_stream_alignment_descriptor";
            case 7 -> "target_background_grid_descriptor";
            case 8 -> "Video_window_descriptor";
            case 9 -> "CA_descriptor";
            case 10 -> "ISO_639_language_descriptor";
            case 11 -> "System_clock_descriptor";
            case 12 -> "Multiplex_buffer_utilization_descriptor";
            case 13 -> "Copyright_descriptor";
            case 14 -> "Maximum_bitrate_descriptor";
            case 15 -> "Private_data_indicator_descriptor";
            case 16 -> "Smoothing_buffer_descriptor";
            case 17 -> "STD_descriptor";
            case 18 -> "IBP_descriptor";
            case 19 -> "DSM-CC Carousel_Identifier_descriptor";
            case 20 -> "DSM-CC Association_tag_descriptor";
            case 21 -> "DSM-CC Deferred_Association_tags_descriptor";
            case 23 -> "NPT_reference_descriptor";
            case 24 -> "NPT_endpoint_descriptor";
            case 25 -> "stream_mode_descriptor";
            case 26 -> "stream_event_descriptor";
            case 27 -> "MPEG4_video_descriptor";
            case 28 -> "MPEG4_audio_descriptor";
            case 29 -> "IOD_descriptor";
            case 30 -> "SL_descriptor";
            case 31 -> "FMC_descriptor";
            case 32 -> "External_ES_ID_descriptor";
            case 33 -> "MuxCode_descriptor";
            case 34 -> "FMXBufferSize_descriptor";
            case 35 -> "MultiplexBuffer_descriptor";
            case 36 -> "ContentLabeling_descriptor";
            case 37 -> "metadata_pointer_descriptor";
            case 38 -> "metadata_descriptor";
            case 39 -> "metadata_STD_descriptor";
            case 40 -> "AVC_video_descriptor";
            case 41 -> "IPMP_descriptor";
            case 42 -> "AVC_timing_and_HRD_descriptor";
            case 43 -> "MPEG2_AAC_audio_descriptor";
            case 44 -> "FlexMuxTiming_descriptor";
            case 45 -> "MPEG-4_text_descriptor";
            case 46 -> "MPEG-4_audio_extension_descriptor";
            case 47 -> "Auxiliary_video_stream_descriptor";
            case 48 -> "SVC extension descriptor";
            case 49 -> "MVC extension descriptor";
            case 50 -> "J2K video descriptor";
            case 51 -> "MVC operation point descriptor";
            case 52 -> "MPEG2_stereoscopic_video_format_descriptor";
            case 53 -> "Stereoscopic_program_info_descriptor";
            case 54 -> "Stereoscopic_video_info_descriptor";
            case 55 -> "Transport_profile_descriptor";
            case 56 -> "HEVC video descriptor";
            case 57 -> "VVC video descriptor";
            case 58 -> "EVC video descriptor";
            case 63 -> "Extension_descriptor";
            case 64 -> "network_name_descriptor";
            case 65 -> "service_list_descriptor";
            case 66 -> "stuffing_descriptor";
            case 67 -> "satellite_delivery_system_descriptor";
            case 68 -> "cable_delivery_system_descriptor";
            case 69 -> "VBI_data_descriptor";
            case 70 -> "VBI_teletext_descriptor";
            case 71 -> "bouquet_name_descriptor";
            case 72 -> "service_descriptor";
            case 73 -> "country_availability_descriptor";
            case 74 -> "linkage_descriptor";
            case 75 -> "NVOD_reference_descriptor";
            case 76 -> "time_shifted_service_descriptor";
            case 77 -> "short_event_descriptor";
            case 78 -> "extended_event_descriptor";
            case 79 -> "time_shifted_event_descriptor";
            case 80 -> "component_descriptor";
            case 81 -> "mosaic_descriptor";
            case 82 -> "stream_identifier_descriptor";
            case 83 -> "CA_identifier_descriptor";
            case 84 -> "content_descriptor";
            case 85 -> "parental_rating_descriptor";
            case 86 -> "teletext_descriptor";
            case 87 -> "telephone_descriptor";
            case 88 -> "local_time_offset_descriptor";
            case 89 -> "subtitling_descriptor";
            case 90 -> "terrestrial_delivery_system_descriptor";
            case 91 -> "multilingual_network_name_descriptor";
            case 92 -> "multilingual_bouquet_name_descriptor";
            case 93 -> "multilingual_service_name_descriptor";
            case 94 -> "multilingual_component_descriptor";
            case 95 -> "private_data_specifier_descriptor";
            case 96 -> "service_move_descriptor";
            case 97 -> "short_smoothing_buffer_descriptor";
            case 98 -> "frequency_list_descriptor";
            case 99 -> "partial_transport_stream_descriptor";
            case 100 -> "data_broadcast_descriptor";
            case 101 -> "scrambling_descriptor";
            case 102 -> "data_broadcast_id_descriptor";
            case 103 -> "transport_stream_descriptor";
            case 104 -> "DSNG_descriptor";
            case 105 -> "PDC_descriptor";
            case 106 -> "AC-3_descriptor";
            case 107 -> "ancillary_data_descriptor";
            case 108 -> "cell_list_descriptor";
            case 109 -> "cell_frequency_link_descriptor";
            case 110 -> "announcement_support_descriptor";
            case 111 -> "application_signalling_descriptor";
            case 112 -> "adaptation_field_data_descriptor";
            case 113 -> "service_identifier_descriptor";
            case 114 -> "service_availability_descriptor";
            case 115 -> "default_authority_descriptor";
            case 116 -> "related_content_descriptor";
            case 117 -> "TVA_id_descriptor";
            case 118 -> "content_identifier_descriptor/TV-Anytime serial recordings descriptor";
            case 119 -> "time_slice_fec_identifier_descriptor";
            case 120 -> "ECM_repetition_rate_descriptor";
            case 121 -> "S2_satellite_delivery_system_descriptor";
            case 122 -> "enhanced_AC-3_descriptor";
            case 123 -> "DTS descriptor";
            case 124 -> "AAC descriptor";
            case 125 -> "XAIT location descriptor";
            case 126 -> "FTA_content_management_descriptor";
            case 127 -> "extension descriptor";
            case 128 -> "user defined: AV1 video descriptor";
            case 129 -> "user defined: UPC logic_channel_descriptor/ATSC AC-3 audio descriptor";
            case 130 -> "user defined: Viasat private: Logic_channel_dscriptor";
            case 131 -> "user defined: EACEM Logic_channel_descriptor / NorDig private: Logic_channel_descriptor version 1 / DTG logical_channel_descriptor";
            case 132 -> "user defined: EACEM Preferred_name_list_descriptor / DTG preferred_name_list_descriptor";
            case 133 -> "user defined: EACEM Preferred_name_identifier_descriptor / DTG preferred_name_identifier_descriptor";
            case 134 -> "user defined: EACEM stream_identifier_descriptor / DTG service_attribute_descriptor";
            case 135 -> "user defined: Ziggo/OpenTV Video On Demand delivery descriptor / NORDIG Logical_channel_descriptor version 2 / DTG short_service_name_descriptor";
            case 136 -> "user defined: EACEM private: HD_simulcast_logical_channel_descriptor / YOUSEE Event tag descriptor / DTG HD_simulcast_logical_channel_descriptor/ hdmv_copy_control_descriptor";
            case 137 -> "user defined: OpenTV private descriptor / DTG guidance_descriptor";
            case 138 -> "user defined: SCTE-35 Cue Identifier Descriptor ";
            case 140 -> "user defined: VodaphoneZiggo / UPC blackout_descriptor";
            case 144 -> "user defined: OpenTV module_track_descriptor";
            case 146 -> "user defined: Extended location ID (YOUSEE)";
            case 147 -> "user defined: Ziggo/OpenTV Video On Demand URL";
            case 151 -> "user defined: SCTE adaptation field data descriptor";
            case 160 -> "user defined: NorDig Content Protection Descriptor";
            case 176 -> "user defined: DOVI_video_stream_descriptor";
            case 196 -> "user defined: anc_data_descriptor";
            case 206 -> "user defined: CI Protection Descriptor";
            case 212 -> "user defined: Ziggo Package Descriptor";
            case 233 -> "user defined: SCTE EBP_descriptor";
            case 241 -> "user defined: Senda private: Channel_list_descriptor";
            case 254 -> "user defined: OpenTV track_tag_descriptor";
            case 255 -> "forbidden";
            default -> 19 <= tag && tag <= 26 ? "Defined in ISO/IEC 13818-6" : (tag <= 63 ? "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Reserved" : (tag <= 254 ? "user defined" : "illegal descriptor tag value"));
        };
    }

    public PID getParentPID() {
        return this.parentTableSection.getParentPID();
    }

    public TransportStream getParentTransportStream() {
        return this.getParentPID().getParentTransportStream();
    }

    public PSI getPSI() {
        return this.getParentTransportStream().getPsi();
    }

    public String getRawDataString() {
        return "0x" + Utils.toHexString(this.privateData, 2, this.descriptorLength) + " \"" + Utils.toSafeString(this.privateData, 2, this.descriptorLength) + "\"";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP t = new KVP("Descriptor: " + this.getDescriptorname(), this.descriptorTag, null);
        this.addGeneralDescriptorInfo(modus, t);
        return t;
    }

    protected void addGeneralDescriptorInfo(int modus, DefaultMutableTreeNode t) {
        if (!Utils.simpleModus(modus)) {
            t.add(new KVP("descriptor_tag", this.descriptorTag, this.getDescriptorname()));
            t.add(new KVP("descriptor_length", this.descriptorLength));
        }
        if (this.getClass().equals(Descriptor.class) || !Utils.simpleModus(modus)) {
            t.add(new KVP("descriptor_data", this.privateData, 2, this.descriptorLength));
        }
    }

    public static String getFEC_innerString(int fecInner) {
        return switch (fecInner) {
            case 0 -> "not defined";
            case 1 -> "1/2 conv. code rate";
            case 2 -> "2/3 conv. code rate";
            case 3 -> "3/4 conv. code rate";
            case 4 -> "5/6 conv. code rate";
            case 5 -> "7/8 conv. code rate";
            case 6 -> "8/9 conv. code rate";
            case 7 -> "3/5 conv. code rate";
            case 8 -> "4/5 conv. code rate";
            case 9 -> "9/10 conv. code rate";
            case 15 -> "no conv. Coding";
            default -> "reserved for future use";
        };
    }

    public static String formatCableFrequency(String f) {
        return Utils.stripLeadingZeros(f.substring(0, 4) + "." + f.substring(4, 8) + " MHz");
    }

    public static String formatCableFrequencyList(String f) {
        return Utils.stripLeadingZeros(f.substring(1, 4) + "." + f.substring(4, 8));
    }

    public static String formatSatelliteFrequency(String f) {
        return Utils.stripLeadingZeros(f.substring(0, 3) + "." + f.substring(3, 8) + " GHz");
    }

    public static String formatOrbitualPosition(String f) {
        return Utils.stripLeadingZeros(f.substring(0, 3) + "." + f.charAt(3) + "\u00b0");
    }

    public static String formatTerrestrialFrequency(long f) {
        StringBuilder s = new StringBuilder();
        Object freq = Long.toString(f * 10L);
        if (((String)freq).length() < 7) {
            freq = "0000000".substring(((String)freq).length()) + (String)freq;
        }
        s.append((CharSequence)freq, 0, ((String)freq).length() - 6).append('.').append(((String)freq).substring(((String)freq).length() - 6)).append(" MHz");
        return Utils.stripLeadingZeros(s.toString());
    }

    public static String formatSymbolRate(String f) {
        return Utils.stripLeadingZeros(f.substring(0, 3) + "." + f.substring(3, 7) + " Msymbol/s");
    }

    public static String getServiceTypeString(int serviceType) {
        return switch (serviceType) {
            case 0 -> "reserved for future use";
            case 1 -> "digital television service";
            case 2 -> "digital radio sound service";
            case 3 -> "Teletext service";
            case 4 -> "NVOD reference service";
            case 5 -> "NVOD time-shifted service";
            case 6 -> "mosaic service";
            case 7 -> "FM radio service";
            case 8 -> "DVB SRM service";
            case 9 -> "reserved for future use";
            case 10 -> "advanced codec digital radio sound service";
            case 11 -> "advanced codec mosaic service";
            case 12 -> "data broadcast service";
            case 13 -> "reserved for Common Interface Usage (EN 50221)";
            case 14 -> "RCS Map (see EN 301 790)";
            case 15 -> "RCS FLS (see EN 301 790)";
            case 16 -> "DVB MHP service";
            case 17 -> "MPEG-2 HD digital television service";
            case 18 -> "reserved for future use";
            case 19 -> "reserved for future use";
            case 20 -> "reserved for future use";
            case 21 -> "reserved for future use";
            case 22 -> "H.264/AVC SD digital television service";
            case 23 -> "H.264/AVC SD NVOD time-shifted service";
            case 24 -> "H.264/AVC SD NVOD reference service";
            case 25 -> "H.264/AVC HD digital television service";
            case 26 -> "H.264/AVC HD NVOD time-shifted service";
            case 27 -> "H.264/AVC HD NVOD reference service";
            case 28 -> "H.264/AVC frame compatible plano-stereoscopic HD digital television service";
            case 29 -> "H.264/AVC frame compatible plano-stereoscopic HD NVOD time-shifted service";
            case 30 -> "H.264/AVC frame compatible plano-stereoscopic HD NVOD reference service";
            case 31 -> "HEVC digital television service";
            case 32 -> "HEVC UHD digital television service with HDR and/or a frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz, or a resolution greater than 3840x2160, SDR or HDR, with a frame rate up to 60Hz";
            case 33 -> "VVC digital television service";
            case 34 -> "AVS3 digital television service";
            case 132 -> "Sagem firmware download service";
            case 135 -> "Sagem OpenTV out_of_list_service";
            case 136 -> "Sagem OpenTV in_list_service";
            default -> 33 <= serviceType && serviceType <= 127 ? "reserved for future use" : (128 <= serviceType && serviceType <= 254 ? "user defined" : "Illegal value");
        };
    }

    public static String getComponentDescriptorString(int stream_content, int stream_content_ext, int component_type) {
        switch (stream_content) {
            case 0: {
                return "reserved for future use";
            }
            case 1: {
                return Descriptor.getComponentType0x01String(component_type);
            }
            case 2: {
                return Descriptor.getComponentType0x02String(component_type);
            }
            case 3: {
                return Descriptor.getComponentType0x03String(component_type);
            }
            case 4: {
                if (component_type < 127) {
                    return "reserved for AC-3 audio modes: " + AC3Descriptor.getComponentTypeString(component_type);
                }
                return "reserved for enhanced AC-3 audio modes: " + AC3Descriptor.getComponentTypeString(component_type);
            }
            case 5: {
                return Descriptor.getComponentType0x05String(component_type);
            }
            case 6: {
                return Descriptor.getComponentType0x06String(component_type);
            }
            case 7: {
                if (component_type < 127) {
                    return "reserved for DTS audio modes";
                }
                return "reserved for future use";
            }
            case 8: {
                return switch (component_type) {
                    case 0 -> "reserved for future use";
                    case 1 -> "DVB SRM data";
                    default -> "reserved for DVB CPCM modes";
                };
            }
            case 9: {
                return Descriptor.getComponentType0x09String(stream_content_ext, component_type);
            }
            case 11: {
                if (stream_content_ext == 14) {
                    return Descriptor.getNextGenerationAudioComponentTypeString(component_type);
                }
                if (stream_content_ext == 15) {
                    return switch (component_type) {
                        case 0 -> "less than 16:9 aspect ratio";
                        case 1 -> "16:9 aspect ratio";
                        case 2 -> "greater than 16:9 aspect ratio";
                        case 3 -> "plano-stereoscopic top and bottom (TaB) frame-packing";
                        case 4 -> "HLG10 HDR";
                        case 5 -> "HEVC temporal video subset for a frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz";
                        case 6 -> "SMPTE ST 2094-10 DMI format";
                        case 7 -> "SL-HDR2 DMI format";
                        case 8 -> "SMPTE ST 2094-40 DMI format";
                        case 9 -> "PQ10 HDR";
                        case 10 -> "T/UWA 005 DMI format";
                        default -> "reserved for future use";
                    };
                }
                return "reserved for future use";
            }
        }
        if (stream_content < 11) {
            return "reserved for future use";
        }
        return "user defined";
    }

    public static String getComponentType0x09String(int stream_content_ext, int component_type) {
        return switch (stream_content_ext) {
            case 0 -> {
                switch (component_type) {
                    case 0: {
                        yield "HEVC Main Profile high definition video, 50 Hz";
                    }
                    case 1: {
                        yield "HEVC Main 10 Profile high definition video, 50 Hz";
                    }
                    case 2: {
                        yield "HEVC Main Profile high definition video, 60 Hz";
                    }
                    case 3: {
                        yield "HEVC Main 10 Profile high definition video, 60 Hz";
                    }
                    case 4: {
                        yield "HEVC ultra high definition video";
                    }
                    case 5: {
                        yield "HEVC ultra high definition video with PQ10 HDR with a frame rate lower than or equal to 60 Hz";
                    }
                    case 6: {
                        yield "HEVC ultra high definition video, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz without a half frame rate HEVC temporal video sub-bitstream";
                    }
                    case 7: {
                        yield "HEVC ultra high definition video with PQ10 HDR, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz without a half frame rate HEVC temporal video sub-bit-stream";
                    }
                    case 8: {
                        yield "HEVC ultra high definition video with a resolution up to 7680x4320";
                    }
                    case 16: {
                        yield "VVC Main 10 Profile with resolution up to 3840x2160, frame rate up to 60 Hz";
                    }
                    case 17: {
                        yield "VVC Main 10 Profile with resolution up to 3840x2160, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz ";
                    }
                    case 18: {
                        yield "VVC Main 10 Profile with resolution up to 7680x4320, frame rate up to 60 Hz";
                    }
                    case 19: {
                        yield "VVC Main 10 Profile with resolution up to 7680x4320, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz ";
                    }
                    case 32: {
                        yield "AVS3 High 10 Profile with resolution up to 3840x2160, frame rate up to 60 Hz";
                    }
                    case 33: {
                        yield "AVS3 High 10 Profile with resolution up to 3840x2160, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz ";
                    }
                    case 34: {
                        yield "AVS3 High 10 Profile with resolution up to 7680x4320, frame rate up to 60 Hz";
                    }
                    case 35: {
                        yield "AVS3 High 10 Profile with resolution up to 7680x4320, frame rate of 100 Hz, 120 000/1 001 Hz, or 120 Hz ";
                    }
                }
                yield "reserved for future use";
            }
            case 1 -> {
                switch (component_type) {
                    case 0: {
                        yield "AC-4 main audio, mono";
                    }
                    case 1: {
                        yield "AC-4 main audio, mono, dialogue enhancement enabled";
                    }
                    case 2: {
                        yield "AC-4 main audio, stereo";
                    }
                    case 3: {
                        yield "AC-4 main audio, stereo, dialogue enhancement enabled";
                    }
                    case 4: {
                        yield "AC-4 main audio, multichannel";
                    }
                    case 5: {
                        yield "AC-4 main audio, multichannel, dialogue enhancement enabled";
                    }
                    case 6: {
                        yield "AC-4 broadcast-mix audio description, mono, for the visually impaired";
                    }
                    case 7: {
                        yield "AC-4 broadcast-mix audio description, mono, for the visually impaired, dialogue enhancement enabled";
                    }
                    case 8: {
                        yield "AC-4 broadcast-mix audio description, stereo, for the visually impaired";
                    }
                    case 9: {
                        yield "AC-4 broadcast-mix audio description, stereo, for the visually impaired, dialogue enhancement enabled";
                    }
                    case 10: {
                        yield "AC-4 broadcast-mix audio description, multichannel, for the visually impaired";
                    }
                    case 11: {
                        yield "AC-4 broadcast-mix audio description, multichannel, for the visually impaired, dialogue enhancement enabled";
                    }
                    case 12: {
                        yield "AC-4 receiver-mix audio description, mono, for the visually impaired";
                    }
                    case 13: {
                        yield "AC-4 receiver-mix audio description, stereo, for the visually impaired";
                    }
                    case 14: {
                        yield "AC-4 Part-2";
                    }
                    case 15: {
                        yield "MPEG-H Audio LC Profile";
                    }
                    case 16: {
                        yield "DTS-UHD main audio, mono";
                    }
                    case 17: {
                        yield "DTS-UHD main audio, mono, dialogue enhancement enabled ";
                    }
                    case 18: {
                        yield "DTS-UHD main audio, stereo";
                    }
                    case 19: {
                        yield "DTS-UHD main audio, stereo, dialogue enhancement enabled";
                    }
                    case 20: {
                        yield "DTS-UHD main audio, multichannel";
                    }
                    case 21: {
                        yield "DTS-UHD main audio, multichannel, dialogue enhancement enabled";
                    }
                    case 22: {
                        yield "DTS-UHD broadcast-mix audio description, mono, for the visually impaired ";
                    }
                    case 23: {
                        yield "DTS-UHD broadcast-mix audio description, mono, for the visually impaired, dialogue enhancement enabled";
                    }
                    case 24: {
                        yield "DTS-UHD broadcast-mix audio description, stereo, for the visually impaired";
                    }
                    case 25: {
                        yield "DTS-UHD broadcast-mix audio description, stereo, for the visually impaired, dialogue enhancement enabled";
                    }
                    case 26: {
                        yield "DTS-UHD broadcast-mix audio description, multichannel, for the visually impaired";
                    }
                    case 27: {
                        yield "DTS-UHD broadcast-mix audio description, multichannel, for the visually impaired, dialogue enhancement enabled ";
                    }
                    case 28: {
                        yield "DTS-UHD receiver-mix audio description, mono, for the visually impaired ";
                    }
                    case 29: {
                        yield "DTS-UHD receiver-mix audio description, stereo, for the visually impaired ";
                    }
                    case 30: {
                        yield "DTS-UHD NGA Audio";
                    }
                    case 32: {
                        yield "AVS3-P3 Next Generation Audio (NGA)";
                    }
                    case 33: {
                        yield "AVS3-P3 broadcast-mix accessibility components";
                    }
                    case 34: {
                        yield "AVS3-P3 receiver-mix accessibility components";
                    }
                }
                yield "reserved for future use";
            }
            case 2 -> "TTML subtitles";
            default -> "reserved for future use";
        };
    }

    public static String getNextGenerationAudioComponentTypeString(int component_type) {
        StringBuilder res = new StringBuilder();
        if ((component_type & 0x40) != 0) {
            res.append("content is pre-rendered for consumption with headphones, ");
        }
        if ((component_type & 0x20) != 0) {
            res.append("content enables interactivity, ");
        }
        if ((component_type & 0x10) != 0) {
            res.append("content enables dialogue enhancement, ");
        }
        if ((component_type & 8) != 0) {
            res.append("content contains spoken subtitles, ");
        }
        if ((component_type & 4) != 0) {
            res.append("content contains audio description, ");
        }
        res.append("preferred reproduction channel layout: ");
        switch (component_type & 3) {
            case 0: {
                res.append("no preference");
                break;
            }
            case 1: {
                res.append("stereo");
                break;
            }
            case 2: {
                res.append("two-dimensional");
                break;
            }
            case 3: {
                res.append("three-dimensional");
                break;
            }
            default: {
                res.append("Illegal value");
            }
        }
        return res.toString();
    }

    public static String getComponentType0x01String(int component_type) {
        return switch (component_type) {
            case 0 -> "reserved for future use";
            case 1 -> "MPEG-2 video, 4:3 aspect ratio, 25 Hz";
            case 2 -> "MPEG-2 video, 16:9 aspect ratio with pan vectors, 25 Hz";
            case 3 -> "MPEG-2 video, 16:9 aspect ratio without pan vectors, 25 Hz";
            case 4 -> "MPEG-2 video, > 16:9 aspect ratio, 25 Hz";
            case 5 -> "MPEG-2 video, 4:3 aspect ratio, 30 Hz";
            case 6 -> "MPEG-2 video, 16:9 aspect ratio with pan vectors, 30 Hz";
            case 7 -> "MPEG-2 video, 16:9 aspect ratio without pan vectors, 30 Hz";
            case 8 -> "MPEG-2 video, > 16:9 aspect ratio, 30 Hz";
            case 9 -> "MPEG-2 high definition video, 4:3 aspect ratio, 25 Hz";
            case 10 -> "MPEG-2 high definition video, 16:9 aspect ratio with pan vectors, 25 Hz";
            case 11 -> "MPEG-2 high definition video, 16:9 aspect ratio without pan vectors, 25 Hz";
            case 12 -> "MPEG-2 high definition video, > 16:9 aspect ratio, 25 Hz";
            case 13 -> "MPEG-2 high definition video, 4:3 aspect ratio, 30 Hz";
            case 14 -> "MPEG-2 high definition video, 16:9 aspect ratio with pan vectors, 30 Hz";
            case 15 -> "MPEG-2 high definition video, 16:9 aspect ratio without pan vectors, 30 Hz";
            case 16 -> "MPEG-2 high definition video, > 16:9 aspect ratio, 30 Hz";
            case 255 -> "reserved for future use";
            default -> 17 <= component_type && component_type <= 175 ? "reserved for future use" : (176 <= component_type && component_type <= 254 ? "user defined" : "Illegal value");
        };
    }

    public static String getComponentType0x02String(int component_type) {
        return switch (component_type) {
            case 0 -> "reserved for future use";
            case 1 -> "MPEG-1 Layer 2 audio, single mono channel";
            case 2 -> "MPEG-1 Layer 2 audio, dual mono channel";
            case 3 -> "MPEG-1 Layer 2 audio, stereo (2 channel)";
            case 4 -> "MPEG-1 Layer 2 audio, multi-lingual, multi-channel";
            case 5 -> "MPEG-1 Layer 2 audio, surround sound";
            case 64 -> "MPEG-1 Layer 2 audio description for the visually impaired";
            case 65 -> "MPEG-1 Layer 2 audio for the hard of hearing";
            case 66 -> "receiver-mixed supplementary audio as per annex E of TS 101 154";
            case 71 -> "MPEG-1 Layer 2 audio, receiver-mix audio description";
            case 72 -> "MPEG-1 Layer 2 audio, broadcast-mix audio description";
            case 255 -> "reserved for future use";
            default -> 6 <= component_type && component_type <= 63 ? "reserved for future use" : (67 <= component_type && component_type <= 175 ? "reserved for future use" : (176 <= component_type && component_type <= 254 ? "user defined" : "Illegal value"));
        };
    }

    public static String getComponentType0x03String(int component_type) {
        return switch (component_type) {
            case 0 -> "reserved for future use";
            case 1 -> "EBU Teletext subtitles";
            case 2 -> "associated EBU Teletext";
            case 3 -> "VBI data";
            case 16 -> "DVB subtitles (normal) with no monitor aspect ratio criticality";
            case 17 -> "DVB subtitles (normal) for display on 4:3 aspect ratio monitor";
            case 18 -> "DVB subtitles (normal) for display on 16:9 aspect ratio monitor";
            case 19 -> "DVB subtitles (normal) for display on 2.21:1 aspect ratio monitor";
            case 20 -> "DVB subtitles (normal) for display on a high definition monitor";
            case 21 -> "DVB subtitles (normal) with plano-stereoscopic disparity for display on a high definition monitor";
            case 22 -> "DVB subtitles (normal) for display on an ultra high definition monitor";
            case 32 -> "DVB subtitles (for the hard of hearing) with no monitor aspect ratio criticality";
            case 33 -> "DVB subtitles (for the hard of hearing) for display on 4:3 aspect ratio monitor";
            case 34 -> "DVB subtitles (for the hard of hearing) for display on 16:9 aspect ratio monitor";
            case 35 -> "DVB subtitles (for the hard of hearing) for display on 2.21:1 aspect ratio monitor";
            case 36 -> "DVB subtitles (for the hard of hearing) for display on a high definition monitor";
            case 37 -> "DVB subtitles (for the hard of hearing) with planostereoscopic disparity for display on a high definition monitor";
            case 38 -> "DVB subtitles (for the hard of hearing) for display on an ultra high definition monitor";
            case 48 -> "Open (in-vision) sign language interpretation for the deaf";
            case 49 -> "Closed sign language interpretation for the deaf";
            case 64 -> "video up-sampled from standard definition source material";
            case 65 -> "Video is standard dynamic range (SDR)";
            case 66 -> "Video is high dynamic range (HDR) remapped from standard dynamic range (SDR) source material";
            case 67 -> "Video is high dynamic range (HDR) up-converted from standard dynamic range (SDR) source material";
            case 68 -> "Video is standard frame rate, less than or equal to 60 Hz";
            case 69 -> "High frame rate video generated from lower frame rate source material";
            case 128 -> "dependent SAOC-DE data stream";
            case 255 -> "reserved for future use";
            default -> 4 <= component_type && component_type <= 15 ? "reserved for future use" : (21 <= component_type && component_type <= 31 ? "reserved for future use" : (37 <= component_type && component_type <= 47 ? "reserved for future use" : (50 <= component_type && component_type <= 175 ? "reserved for future use" : (176 <= component_type && component_type <= 254 ? "user defined" : "Illegal value"))));
        };
    }

    public static String getComponentType0x05String(int component_type) {
        return switch (component_type) {
            case 0 -> "reserved for future use";
            case 1 -> "H.264/AVC standard definition video, 4:3 aspect ratio, 25 Hz";
            case 2 -> "reserved for future use";
            case 3 -> "H.264/AVC standard definition video, 16:9 aspect ratio, 25 Hz";
            case 4 -> "H.264/AVC standard definition video, > 16:9 aspect ratio, 25 Hz";
            case 5 -> "H.264/AVC standard definition video, 4:3 aspect ratio, 30 Hz";
            case 6 -> "reserved for future use";
            case 7 -> "H.264/AVC standard definition video, 16:9 aspect ratio, 30 Hz";
            case 8 -> "H.264/AVC standard definition video, > 16:9 aspect ratio, 30 Hz";
            case 11 -> "H.264/AVC high definition video, 16:9 aspect ratio, 25 Hz";
            case 12 -> "H.264/AVC high definition video, > 16:9 aspect ratio, 25 Hz";
            case 15 -> "H.264/AVC high definition video, 16:9 aspect ratio, 30 Hz";
            case 16 -> "H.264/AVC high definition video, > 16:9 aspect ratio, 30 Hz";
            case 128 -> "H.264/AVC planostereoscopic frame compatible high definition video, 16:9 aspect ratio, 25 Hz, Side-by-Side";
            case 129 -> "H.264/AVC planostereoscopic frame compatible high definition video, 16:9 aspect ratio, 25 Hz, Top-and-Bottom";
            case 130 -> "H.264/AVC planostereoscopic frame compatible high definition video, 16:9 aspect ratio, 30 Hz, Side-by-Side";
            case 131 -> "H.264/AVC stereoscopic frame compatible high definition video, 16:9 aspect ratio, 30 Hz, Top-and-Bottom";
            case 132 -> "H.264/MVC dependent view, plano-stereoscopic service compatible video";
            case 255 -> "reserved for future use";
            default -> 9 <= component_type && component_type <= 10 ? "reserved for future use" : (13 <= component_type && component_type <= 14 ? "reserved for future use" : (17 <= component_type && component_type <= 175 ? "reserved for future use" : (176 <= component_type && component_type <= 254 ? "user defined" : "Illegal value")));
        };
    }

    public static String getComponentType0x06String(int component_type) {
        return switch (component_type) {
            case 0 -> "reserved for future use";
            case 1 -> "HE-AAC audio, single mono channel";
            case 2 -> "reserved for future use";
            case 3 -> "HE-AAC audio, stereo";
            case 4 -> "reserved for future use";
            case 5 -> "HE-AAC audio, surround sound";
            case 64 -> "HE-AAC audio description for the visually impaired";
            case 65 -> "HE-AAC audio for the hard of hearing";
            case 66 -> "HE-AAC receiver-mixed supplementary audio as per annex E of TS 101 154 [10]";
            case 67 -> "HE-AAC v2 audio, stereo";
            case 68 -> "HE-AAC v2 audio description for the visually impaired";
            case 69 -> "HE-AAC v2 audio for the hard of hearing";
            case 70 -> "HE-AAC v2 receiver-mixed supplementary audio as per annex E of TS 101 154 [10]";
            case 71 -> "HE-AAC receiver mix audio description for the visually impaired";
            case 72 -> "HE-AAC broadcaster mix audio description for the visually impaired";
            case 73 -> "HE-AAC v2 receiver mix audio description for the visually impaired";
            case 74 -> "HE-AAC v2 broadcaster mix audio description for the visually impaired";
            case 160 -> "HE AAC, or HE AAC v2 with SAOC-DE ancillary data";
            case 255 -> "reserved for future use";
            default -> 6 <= component_type && component_type <= 63 ? "reserved for future use" : (75 <= component_type && component_type <= 175 ? "reserved for future use" : (176 <= component_type && component_type <= 254 ? "user defined" : "Illegal value"));
        };
    }

    public static <U extends Descriptor> List<U> findGenericDescriptorsInList(Iterable<? extends Descriptor> descriptorList, Class<U> u) {
        ArrayList<Descriptor> result = new ArrayList<Descriptor>();
        for (Descriptor descriptor : descriptorList) {
            if (!descriptor.getClass().equals(u)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static <U extends Descriptor> Object findDescriptorApplyFunc(Iterable<Descriptor> descriptorList, Class<U> u, Function<U, Object> fun) {
        for (Descriptor element : descriptorList) {
            if (!element.getClass().equals(u)) continue;
            return fun.apply(element);
        }
        return null;
    }

    public static <U extends Descriptor, V> List<V> findDescriptorApplyListFunc(Iterable<Descriptor> descriptorList, Class<U> u, Function<U, List<V>> fun) {
        for (Descriptor element : descriptorList) {
            if (!element.getClass().equals(u)) continue;
            return fun.apply(element);
        }
        return null;
    }

    public static String getProfileLevelString(int profile_and_level) {
        return switch (profile_and_level) {
            case 16 -> "Main profile, level 1";
            case 17 -> "Main profile, level 2";
            case 18 -> "Main profile, level 3";
            case 19 -> "Main profile, level 4";
            case 24 -> "Scalable Profile, level 1";
            case 25 -> "Scalable Profile, level 2";
            case 26 -> "Scalable Profile, level 3";
            case 27 -> "Scalable Profile, level 4";
            case 32 -> "Speech profile, level 1";
            case 33 -> "Speech profile, level 2";
            case 40 -> "Synthesis profile, level 1";
            case 41 -> "Synthesis profile, level 2";
            case 42 -> "Synthesis profile, level 3";
            case 48 -> "High quality audio profile, level 1";
            case 49 -> "High quality audio profile, level 2";
            case 50 -> "High quality audio profile, level 3";
            case 51 -> "High quality audio profile, level 4";
            case 52 -> "High quality audio profile, level 5";
            case 53 -> "High quality audio profile, level 6";
            case 54 -> "High quality audio profile, level 7";
            case 55 -> "High quality audio profile, level 8";
            case 56 -> "Low delay audio profile, level 1";
            case 57 -> "Low delay audio profile, level 2";
            case 58 -> "Low delay audio profile, level 3";
            case 59 -> "Low delay audio profile, level 4";
            case 60 -> "Low delay audio profile, level 5";
            case 61 -> "Low delay audio profile, level 6";
            case 62 -> "Low delay audio profile, level 7";
            case 63 -> "Low delay audio profile, level 8";
            case 64 -> "Natural audio profile, level 1";
            case 65 -> "Natural audio profile, level 2";
            case 66 -> "Natural audio profile, level 3";
            case 67 -> "Natural audio profile, level 4";
            case 72 -> "Mobile audio internetworking profile, level 1";
            case 73 -> "Mobile audio internetworking profile, level 2";
            case 74 -> "Mobile audio internetworking profile, level 3";
            case 75 -> "Mobile audio internetworking profile, level 4";
            case 76 -> "Mobile audio internetworking profile, level 5";
            case 77 -> "Mobile audio internetworking profile, level 6";
            case 80 -> "AAC profile, level 1";
            case 81 -> "AAC profile, level 2";
            case 82 -> "AAC profile, level 4";
            case 83 -> "AAC profile, level 5";
            case 88 -> "High efficiency AAC profile, level 2";
            case 89 -> "High efficiency AAC profile, level 3";
            case 90 -> "High efficiency AAC profile, level 4";
            case 91 -> "High efficiency AAC profile, level 5";
            case 96 -> "High efficiency AAC v2 profile, level 2";
            case 97 -> "High efficiency AAC v2 profile, level 3";
            case 98 -> "High efficiency AAC v2 profile, level 4";
            case 99 -> "High efficiency AAC v2 profile, level 5";
            case 255 -> "Audio profile and level not specified by the MPEG-4_audio_profile_and_level field in this descriptor";
            default -> "Reserved";
        };
    }

    protected static String getMPEGCarriageFlagsString(int mPEG_carriage_flags) {
        return mpeg_carriage_flags_list.get(mPEG_carriage_flags);
    }

    protected static String getMetaDataApplicationFormatString(int metadata_application_format) {
        return metadata_application_format_list.get(metadata_application_format);
    }

    public static String getMetaDataFormatString(int metadata_format) {
        return metadata_format_list.get(metadata_format);
    }

    public String toString() {
        return "Descriptor{descriptorTag=" + this.descriptorTag + ", descriptorLength=" + this.descriptorLength + ", privateData=" + Arrays.toString(this.privateData) + ", parentTableSection=" + String.valueOf(this.parentTableSection) + "}";
    }
}

