/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AACDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AACMpeg2Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AVCTimingAndHRDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AVCVideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AdaptationFieldDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AncillaryDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ApplicationSignallingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AssociationTagDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AudioStreamDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.BouquetNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CADescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CAIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CableDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CarouselIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CellFrequencyLinkDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CellListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ComponentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ContentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ContentIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CopyrightDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CountryAvailabilityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataBroadcastDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataBroadcastIDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataStreamAlignmentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DefaultAuthorityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.EnhancedAC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ExtendedEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.FTAContentManagmentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.FrequencyListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.HEVCVideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.HierarchyDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.IBPDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ISO639LanguageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.JPEG2000VideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LinkageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LocalTimeOffsetDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MaximumBitrateDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MetaDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MetaDataPointerDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MosaicDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Mpeg4AudioDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MultilingualBouquetNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MultilingualNetworkNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MultilingualServiceNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.MultiplexBufferUtilizationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.NVODReferenceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.NetworkNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.PDCDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ParentalRatingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.PartialTransportStreamDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.PrivateDataIndicatorDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.PrivateDataSpecifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RegistrationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RelatedContentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.S2SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.STDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ScramblingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceAvailabilityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ShortEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SmoothingBufferDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.StreamEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.StreamIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SubtitlingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SystemClockDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TargetBackGroundDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TeletextDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TerrestrialDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TimeShiftedEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TimeShiftedServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TimeSliceFecIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.VBIDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.VVCVideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.VideoStreamDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.VideoWindowDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.ApplicationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.ApplicationNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.ApplicationUsageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.DVBJApplicationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.DVBJApplicationLocationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.ExternalApplicationAuthorizationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.SimpleApplicationBoundaryDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.SimpleApplicationLocationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.TransportProtocolDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.AC4Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.AudioPreselectionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.CIAncillaryDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.NetworkChangeNotifyDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.S2XSatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.SHDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.ServiceProminenceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.ServiceRelocatedDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.SupplementaryAudioDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.T2DeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.T2MIDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.TargetRegionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.TargetRegionNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.TtmlSubtitlingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.URILinkageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.VvcSubpicturesDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.HEVCTimingAndHRDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.JpegXsVideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.MPEGExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.INTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.IPMACPlatformNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.IPMACPlatformProviderNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.IPMACStreamLocationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.intable.TargetIPSlashDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.au.LogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.avs.AVS3AudioDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.avs.AVS3VideoDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international.CosBatSelectionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international.CosInformationParametersDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international.CosLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international.CosTimezoneDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.casema.ZiggoPackageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.casema.ZiggoVodDeliveryDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.casema.ZiggoVodURLDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ciplus.CIProtectionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg.GuidanceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg.ServiceAttributeDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.eaccam.EACEMStreamIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.eaccam.HDSimulcastLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7LogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7NagraBrandIdDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorDiSEqCTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorOptionsDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorPreferencesDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorSublistNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OttBrandIdDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.nordig.NordigLogicalChannelDescriptorV1;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.nordig.NordigLogicalChannelDescriptorV2;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.opencable.EBPDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.scte.SCTEAdaptationFieldDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.BouquetListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.ServiceListNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.VirtualServiceIDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.upc.UPCLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.uwa.CUVVVideoStreamDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35.AvailDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35.SCTE35Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.scte35.SegmentationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.MessageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.SSUEventNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.SSULocationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.SSUSubgroupAssociationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.SchedulingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.TargetSmartcardDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UpdateDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public final class DescriptorFactory {
    private static final Logger logger = Logger.getLogger(DescriptorFactory.class.getName());

    private DescriptorFactory() {
    }

    public static List<Descriptor> buildDescriptorList(byte[] data, int offset, int len, TableSection tableSection) {
        DescriptorContext descriptorContext = new DescriptorContext();
        return DescriptorFactory.buildDescriptorList(data, offset, len, tableSection, descriptorContext);
    }

    public static List<Descriptor> buildDescriptorList(byte[] data, int offset, int len, TableSection tableSection, DescriptorContext descriptorContext) {
        Descriptor d;
        descriptorContext.setPrivate_data_specifier(PreferencesManager.getDefaultPrivateDataSpecifier());
        ArrayList<Descriptor> r = new ArrayList<Descriptor>();
        for (int t = 0; t < len; t += d.getDescriptorLength() + 2) {
            int descriptorLen = Byte.toUnsignedInt(data[offset + t + 1]);
            byte[] descriptorData = Arrays.copyOfRange(data, offset + t, offset + t + descriptorLen + 2);
            d = DescriptorFactory.getDescriptor(descriptorData, tableSection, descriptorContext);
            r.add(d);
            if (!(d instanceof PrivateDataSpecifierDescriptor)) continue;
            PrivateDataSpecifierDescriptor privateDescriptor = (PrivateDataSpecifierDescriptor)d;
            descriptorContext.setPrivate_data_specifier(privateDescriptor.getPrivateDataSpecifier());
        }
        return r;
    }

    private static Descriptor getDescriptor(byte[] data, TableSection tableSection, DescriptorContext descriptorContext) {
        int descriptorTag = Byte.toUnsignedInt(data[0]);
        try {
            if (descriptorTag == 233) {
                return new EBPDescriptor(data, 0, tableSection);
            }
            if (descriptorTag == 151) {
                return new SCTEAdaptationFieldDataDescriptor(data, 0, tableSection);
            }
            if (descriptorTag == 243 && data[2] == 99 && data[3] == 117 && data[4] == 118 && data[5] == 118) {
                return new CUVVVideoStreamDescriptor(data, 0, tableSection);
            }
            if (descriptorTag >= 128 && tableSection.getTableId() >= 188 && tableSection.getTableId() <= 190 && PreferencesManager.isEnableM7Fastscan()) {
                return DescriptorFactory.getM7Descriptor(data, tableSection);
            }
            if (descriptorTag <= 63) {
                return switch (tableSection.getTableId()) {
                    case 76 -> DescriptorFactory.getINTDescriptor(data, tableSection);
                    case 75 -> DescriptorFactory.getUNTDescriptor(data, tableSection);
                    case 116 -> DescriptorFactory.getAITDescriptor(data, tableSection);
                    case 252 -> DescriptorFactory.getSCTE35Descriptor(data, tableSection);
                    default -> DescriptorFactory.getMPEGDescriptor(data, tableSection);
                };
            }
            if (descriptorTag <= 127) {
                return DescriptorFactory.getDVBSIDescriptor(data, tableSection, descriptorContext);
            }
            return DescriptorFactory.getPrivateDVBSIDescriptor(data, tableSection, descriptorContext);
        }
        catch (RuntimeException iae) {
            Descriptor d = new Descriptor(data, 0, tableSection);
            logger.warning("Fall back for descriptor:" + Byte.toUnsignedInt(data[0]) + " (" + Descriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString() + ", RuntimeException:" + String.valueOf(iae));
            return d;
        }
    }

    private static Descriptor getM7Descriptor(byte[] data, TableSection tableSection) {
        int descriptorTag = Byte.toUnsignedInt(data[0]);
        switch (descriptorTag) {
            case 131: {
                return new M7LogicalChannelDescriptor(data, tableSection);
            }
            case 132: {
                return new M7OperatorNameDescriptor(data, tableSection);
            }
            case 133: {
                return new M7OperatorSublistNameDescriptor(data, tableSection);
            }
            case 134: {
                return new M7OperatorPreferencesDescriptor(data, tableSection);
            }
            case 135: {
                return new M7OperatorDiSEqCTDescriptor(data, tableSection);
            }
            case 136: {
                return new M7OperatorOptionsDescriptor(data, tableSection);
            }
            case 137: {
                return new M7NagraBrandIdDescriptor(data, tableSection);
            }
            case 138: {
                return new M7OttBrandIdDescriptor(data, tableSection);
            }
        }
        M7Descriptor d = new M7Descriptor(data, tableSection);
        logger.info("Not implemented M7Descriptor:" + descriptorTag + " (" + M7Descriptor.getDescriptorname(descriptorTag) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString());
        return d;
    }

    private static Descriptor getPrivateDVBSIDescriptor(byte[] data, TableSection tableSection, DescriptorContext descriptorContext) {
        long private_data_specifier = descriptorContext.getPrivate_data_specifier();
        int descriptor_tag = Byte.toUnsignedInt(data[0]);
        if (private_data_specifier == 1536L) {
            switch (descriptor_tag) {
                case 129: {
                    return new UPCLogicalChannelDescriptor(data, 0, tableSection);
                }
                case 135: {
                    return new ZiggoVodDeliveryDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 22L) {
            switch (descriptor_tag) {
                case 135: {
                    return new ZiggoVodDeliveryDescriptor(data, 0, tableSection);
                }
                case 147: {
                    return new ZiggoVodURLDescriptor(data, 0, tableSection);
                }
                case 212: {
                    return new ZiggoPackageDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 40L) {
            switch (descriptor_tag) {
                case 131: {
                    return new nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.eaccam.LogicalChannelDescriptor(data, 0, tableSection, descriptorContext);
                }
                case 134: {
                    return new EACEMStreamIdentifierDescriptor(data, 0, tableSection);
                }
                case 136: {
                    return new HDSimulcastLogicalChannelDescriptor(data, 0, tableSection, descriptorContext);
                }
            }
        } else if (private_data_specifier == 41L) {
            switch (descriptor_tag) {
                case 131: {
                    return new NordigLogicalChannelDescriptorV1(data, 0, tableSection, descriptorContext);
                }
                case 135: {
                    return new NordigLogicalChannelDescriptorV2(data, tableSection, descriptorContext);
                }
            }
        } else if (private_data_specifier == 64L) {
            switch (descriptor_tag) {
                case 206: {
                    return new CIProtectionDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 164L) {
            switch (descriptor_tag) {
                case 128: {
                    return new CosBatSelectionDescriptor(data, tableSection);
                }
                case 129: {
                    return new CosInformationParametersDescriptor(data, 0, tableSection);
                }
                case 131: {
                    return new CosLogicalChannelDescriptor(data, 0, tableSection, descriptorContext);
                }
                case 136: {
                    return new CosTimezoneDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 9018L) {
            switch (descriptor_tag) {
                case 131: {
                    return new nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg.LogicalChannelDescriptor(data, 0, tableSection, descriptorContext);
                }
                case 134: {
                    return new ServiceAttributeDescriptor(data, 0, tableSection);
                }
                case 137: {
                    return new GuidanceDescriptor(data, tableSection);
                }
            }
        } else if (private_data_specifier >= 12800L && private_data_specifier <= 12815L) {
            switch (descriptor_tag) {
                case 131: {
                    return new LogicalChannelDescriptor(data, 0, tableSection, descriptorContext);
                }
            }
        } else if (private_data_specifier == 1096176470L) {
            switch (descriptor_tag) {
                case 209: {
                    return new AVS3VideoDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 1096176449L) {
            switch (descriptor_tag) {
                case 210: {
                    return new AVS3AudioDescriptor(data, 0, tableSection);
                }
            }
        } else if (private_data_specifier == 1L) {
            switch (descriptor_tag) {
                case 136: {
                    return new ServiceListNameDescriptor(data, tableSection);
                }
                case 147: {
                    return new BouquetListDescriptor(data, tableSection);
                }
                case 209: {
                    return new VirtualServiceIDDescriptor(data, tableSection);
                }
            }
        }
        logger.info("Unimplemented private descriptor, private_data_specifier=" + private_data_specifier + ", descriptortag=" + descriptor_tag + ", tableSection=" + String.valueOf(tableSection));
        return new Descriptor(data, 0, tableSection);
    }

    private static Descriptor getMPEGDescriptor(byte[] data, TableSection tableSection) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 2: {
                return new VideoStreamDescriptor(data, 0, tableSection);
            }
            case 3: {
                return new AudioStreamDescriptor(data, 0, tableSection);
            }
            case 4: {
                return new HierarchyDescriptor(data, 0, tableSection);
            }
            case 5: {
                return new RegistrationDescriptor(data, 0, tableSection);
            }
            case 6: {
                return new DataStreamAlignmentDescriptor(data, 0, tableSection);
            }
            case 7: {
                return new TargetBackGroundDescriptor(data, 0, tableSection);
            }
            case 8: {
                return new VideoWindowDescriptor(data, 0, tableSection);
            }
            case 9: {
                return new CADescriptor(data, 0, tableSection);
            }
            case 10: {
                return new ISO639LanguageDescriptor(data, 0, tableSection);
            }
            case 11: {
                return new SystemClockDescriptor(data, 0, tableSection);
            }
            case 12: {
                return new MultiplexBufferUtilizationDescriptor(data, 0, tableSection);
            }
            case 13: {
                return new CopyrightDescriptor(data, 0, tableSection);
            }
            case 14: {
                return new MaximumBitrateDescriptor(data, 0, tableSection);
            }
            case 15: {
                return new PrivateDataIndicatorDescriptor(data, 0, tableSection);
            }
            case 16: {
                return new SmoothingBufferDescriptor(data, 0, tableSection);
            }
            case 17: {
                return new STDDescriptor(data, 0, tableSection);
            }
            case 18: {
                return new IBPDescriptor(data, 0, tableSection);
            }
            case 19: {
                return new CarouselIdentifierDescriptor(data, tableSection);
            }
            case 20: {
                return new AssociationTagDescriptor(data, 0, tableSection);
            }
            case 26: {
                return new StreamEventDescriptor(data, 0, tableSection);
            }
            case 28: {
                return new Mpeg4AudioDescriptor(data, 0, tableSection);
            }
            case 37: {
                return new MetaDataPointerDescriptor(data, 0, tableSection);
            }
            case 38: {
                return new MetaDataDescriptor(data, 0, tableSection);
            }
            case 40: {
                return new AVCVideoDescriptor(data, 0, tableSection);
            }
            case 42: {
                return new AVCTimingAndHRDDescriptor(data, 0, tableSection);
            }
            case 43: {
                return new AACMpeg2Descriptor(data, 0, tableSection);
            }
            case 50: {
                return new JPEG2000VideoDescriptor(data, 0, tableSection);
            }
            case 56: {
                return new HEVCVideoDescriptor(data, 0, tableSection);
            }
            case 57: {
                return new VVCVideoDescriptor(data, 0, tableSection);
            }
            case 63: {
                return DescriptorFactory.getMPEGExtendedDescriptor(data, tableSection);
            }
        }
        Descriptor descriptor = new Descriptor(data, 0, tableSection);
        logger.info("Not implemented descriptor:" + Byte.toUnsignedInt(data[0]) + " (" + Descriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + descriptor.getRawDataString());
        return descriptor;
    }

    private static MPEGExtensionDescriptor getMPEGExtendedDescriptor(byte[] data, TableSection tableSection) {
        int descriptor_tag_extension = Byte.toUnsignedInt(data[2]);
        switch (descriptor_tag_extension) {
            case 3: {
                return new HEVCTimingAndHRDDescriptor(data, tableSection);
            }
            case 20: {
                return new JpegXsVideoDescriptor(data, tableSection);
            }
        }
        MPEGExtensionDescriptor d = new MPEGExtensionDescriptor(data, tableSection);
        logger.warning("unimplemented MPEGExtensionDescriptor:" + d.getDescriptorTagString() + ", TableSection:" + String.valueOf(tableSection));
        return d;
    }

    private static Descriptor getDVBSIDescriptor(byte[] data, TableSection tableSection, DescriptorContext descriptorContext) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 64: {
                return new NetworkNameDescriptor(data, 0, tableSection);
            }
            case 65: {
                return new ServiceListDescriptor(data, 0, tableSection, descriptorContext);
            }
            case 67: {
                return new SatelliteDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 68: {
                return new CableDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 69: {
                return new VBIDataDescriptor(data, 0, tableSection);
            }
            case 70: {
                return new TeletextDescriptor(data, 0, tableSection);
            }
            case 71: {
                return new BouquetNameDescriptor(data, tableSection);
            }
            case 72: {
                return new ServiceDescriptor(data, tableSection);
            }
            case 73: {
                return new CountryAvailabilityDescriptor(data, 0, tableSection);
            }
            case 74: {
                return new LinkageDescriptor(data, tableSection);
            }
            case 75: {
                return new NVODReferenceDescriptor(data, 0, tableSection);
            }
            case 76: {
                return new TimeShiftedServiceDescriptor(data, 0, tableSection);
            }
            case 77: {
                return new ShortEventDescriptor(data, tableSection);
            }
            case 78: {
                return new ExtendedEventDescriptor(data, tableSection);
            }
            case 79: {
                return new TimeShiftedEventDescriptor(data, 0, tableSection);
            }
            case 80: {
                return new ComponentDescriptor(data, tableSection);
            }
            case 81: {
                return new MosaicDescriptor(data, 0, tableSection);
            }
            case 82: {
                return new StreamIdentifierDescriptor(data, 0, tableSection);
            }
            case 83: {
                return new CAIdentifierDescriptor(data, 0, tableSection);
            }
            case 84: {
                return new ContentDescriptor(data, tableSection);
            }
            case 85: {
                return new ParentalRatingDescriptor(data, 0, tableSection);
            }
            case 86: {
                return new TeletextDescriptor(data, 0, tableSection);
            }
            case 88: {
                return new LocalTimeOffsetDescriptor(data, 0, tableSection);
            }
            case 89: {
                return new SubtitlingDescriptor(data, 0, tableSection);
            }
            case 90: {
                return new TerrestrialDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 91: {
                return new MultilingualNetworkNameDescriptor(data, tableSection);
            }
            case 92: {
                return new MultilingualBouquetNameDescriptor(data, tableSection);
            }
            case 93: {
                return new MultilingualServiceNameDescriptor(data, tableSection);
            }
            case 95: {
                return new PrivateDataSpecifierDescriptor(data, 0, tableSection);
            }
            case 98: {
                return new FrequencyListDescriptor(data, 0, tableSection);
            }
            case 99: {
                return new PartialTransportStreamDescriptor(data, 0, tableSection);
            }
            case 100: {
                return new DataBroadcastDescriptor(data, 0, tableSection);
            }
            case 101: {
                return new ScramblingDescriptor(data, 0, tableSection);
            }
            case 102: {
                return new DataBroadcastIDDescriptor(data, 0, tableSection);
            }
            case 105: {
                return new PDCDescriptor(data, 0, tableSection);
            }
            case 106: {
                return new AC3Descriptor(data, 0, tableSection);
            }
            case 107: {
                return new AncillaryDataDescriptor(data, 0, tableSection);
            }
            case 108: {
                return new CellListDescriptor(data, 0, tableSection);
            }
            case 109: {
                return new CellFrequencyLinkDescriptor(data, 0, tableSection);
            }
            case 111: {
                return new ApplicationSignallingDescriptor(data, 0, tableSection);
            }
            case 112: {
                return new AdaptationFieldDataDescriptor(data, 0, tableSection);
            }
            case 113: {
                return new ServiceIdentifierDescriptor(data, tableSection);
            }
            case 114: {
                return new ServiceAvailabilityDescriptor(data, 0, tableSection);
            }
            case 115: {
                return new DefaultAuthorityDescriptor(data, 0, tableSection);
            }
            case 116: {
                return new RelatedContentDescriptor(data, 0, tableSection);
            }
            case 118: {
                return new ContentIdentifierDescriptor(data, 0, tableSection);
            }
            case 119: {
                return new TimeSliceFecIdentifierDescriptor(data, 0, tableSection);
            }
            case 121: {
                return new S2SatelliteDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 122: {
                return new EnhancedAC3Descriptor(data, 0, tableSection);
            }
            case 124: {
                return new AACDescriptor(data, tableSection);
            }
            case 126: {
                return new FTAContentManagmentDescriptor(data, 0, tableSection);
            }
            case 127: {
                return DescriptorFactory.getDVBExtendedDescriptor(data, tableSection);
            }
        }
        Descriptor d = new Descriptor(data, 0, tableSection);
        logger.info("Not implemented descriptor:" + Byte.toUnsignedInt(data[0]) + " (" + Descriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString());
        return d;
    }

    private static DVBExtensionDescriptor getDVBExtendedDescriptor(byte[] data, TableSection tableSection) {
        int descriptor_tag_extension = Byte.toUnsignedInt(data[2]);
        switch (descriptor_tag_extension) {
            case 4: {
                return new T2DeliverySystemDescriptor(data, 0, tableSection);
            }
            case 5: {
                return new SHDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 6: {
                return new SupplementaryAudioDescriptor(data, 0, tableSection);
            }
            case 7: {
                return new NetworkChangeNotifyDescriptor(data, 0, tableSection);
            }
            case 8: {
                return new nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.MessageDescriptor(data, 0, tableSection);
            }
            case 9: {
                return new TargetRegionDescriptor(data, 0, tableSection);
            }
            case 10: {
                return new TargetRegionNameDescriptor(data, 0, tableSection);
            }
            case 11: {
                return new ServiceRelocatedDescriptor(data, 0, tableSection);
            }
            case 17: {
                return new T2MIDescriptor(data, 0, tableSection);
            }
            case 19: {
                return new URILinkageDescriptor(data, 0, tableSection);
            }
            case 20: {
                return new CIAncillaryDataDescriptor(data, tableSection);
            }
            case 21: {
                return new AC4Descriptor(data, 0, tableSection);
            }
            case 23: {
                return new S2XSatelliteDeliverySystemDescriptor(data, 0, tableSection);
            }
            case 25: {
                return new AudioPreselectionDescriptor(data, 0, tableSection);
            }
            case 32: {
                return new TtmlSubtitlingDescriptor(data, tableSection);
            }
            case 34: {
                return new ServiceProminenceDescriptor(data, 0, tableSection);
            }
            case 35: {
                return new VvcSubpicturesDescriptor(data, tableSection);
            }
        }
        DVBExtensionDescriptor d = new DVBExtensionDescriptor(data, 0, tableSection);
        logger.warning("unimplemented DVBExtensionDescriptor:" + d.getDescriptorTagString() + ", TableSection:" + String.valueOf(tableSection));
        return d;
    }

    private static Descriptor getINTDescriptor(byte[] data, TableSection tableSection) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 12: {
                return new IPMACPlatformNameDescriptor(data, tableSection);
            }
            case 13: {
                return new IPMACPlatformProviderNameDescriptor(data, tableSection);
            }
            case 15: {
                return new TargetIPSlashDescriptor(data, tableSection);
            }
            case 19: {
                return new IPMACStreamLocationDescriptor(data, tableSection);
            }
        }
        INTDescriptor d = new INTDescriptor(data, tableSection);
        logger.info("Not implemented IntDescriptor:" + Byte.toUnsignedInt(data[0]) + " (" + INTDescriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString());
        return d;
    }

    private static Descriptor getUNTDescriptor(byte[] data, TableSection tableSection) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 1: {
                return new SchedulingDescriptor(data, 0, tableSection);
            }
            case 2: {
                return new UpdateDescriptor(data, 0, tableSection);
            }
            case 3: {
                return new SSULocationDescriptor(data, 0, tableSection);
            }
            case 4: {
                return new MessageDescriptor(data, tableSection);
            }
            case 5: {
                return new SSUEventNameDescriptor(data, 0, tableSection);
            }
            case 6: {
                return new TargetSmartcardDescriptor(data, 0, tableSection);
            }
            case 11: {
                return new SSUSubgroupAssociationDescriptor(data, 0, tableSection);
            }
        }
        UNTDescriptor d = new UNTDescriptor(data, 0, tableSection);
        logger.info("Not implemented UNTDescriptor:" + Byte.toUnsignedInt(data[0]) + " (" + UNTDescriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString() + ", pid:" + tableSection.getParentPID().getPid());
        return d;
    }

    private static Descriptor getAITDescriptor(byte[] data, TableSection tableSection) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 0: {
                return new ApplicationDescriptor(data, tableSection);
            }
            case 1: {
                return new ApplicationNameDescriptor(data, tableSection);
            }
            case 2: {
                return new TransportProtocolDescriptor(data, tableSection);
            }
            case 3: {
                return new DVBJApplicationDescriptor(data, tableSection);
            }
            case 4: {
                return new DVBJApplicationLocationDescriptor(data, tableSection);
            }
            case 5: {
                return new ExternalApplicationAuthorizationDescriptor(data, tableSection);
            }
            case 21: {
                return new SimpleApplicationLocationDescriptor(data, tableSection);
            }
            case 22: {
                return new ApplicationUsageDescriptor(data, tableSection);
            }
            case 23: {
                return new SimpleApplicationBoundaryDescriptor(data, tableSection);
            }
        }
        AITDescriptor d = new AITDescriptor(data, tableSection);
        logger.info("Not implemented AITDescriptor:" + Byte.toUnsignedInt(data[0]) + " (" + AITDescriptor.getDescriptorname(Byte.toUnsignedInt(data[0])) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString());
        return d;
    }

    private static Descriptor getSCTE35Descriptor(byte[] data, TableSection tableSection) {
        switch (Byte.toUnsignedInt(data[0])) {
            case 0: {
                return new AvailDescriptor(data, 0, tableSection);
            }
            case 2: {
                return new SegmentationDescriptor(data, 0, tableSection);
            }
        }
        SCTE35Descriptor d = new SCTE35Descriptor(data, 0, tableSection);
        logger.info("Not implemented SCTE35Descriptor:" + Byte.toUnsignedInt(data[0]) + " (" + SCTE35Descriptor.getDescriptorname(Byte.toUnsignedInt(data[0]), tableSection) + ")in section " + TableSection.getTableType(tableSection.getTableId()) + " (" + String.valueOf(tableSection) + ",) data=" + d.getRawDataString());
        return d;
    }
}

