/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class FrequencyListDescriptor
extends Descriptor {
    private List<CentreFrequency> frequencyList = new ArrayList<CentreFrequency>();
    private int codingType = 0;

    public FrequencyListDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.codingType = Utils.getInt(b, offset + 2, 1, 3);
        for (int t = 1; t < this.descriptorLength; t += 4) {
            CentreFrequency s = new CentreFrequency(offset + 2 + t);
            this.frequencyList.add(s);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("coding_type", this.codingType, FrequencyListDescriptor.getCodingTypeString(this.codingType))));
        Utils.addListJTree(t, this.frequencyList, modus, "frequencies");
        return t;
    }

    private static String getCodingTypeString(int codingType) {
        switch (codingType) {
            case 0: {
                return "not defined";
            }
            case 1: {
                return "satellit";
            }
            case 2: {
                return "cable";
            }
            case 3: {
                return "terrestrial";
            }
        }
        return "illegal value codng_type:" + codingType;
    }

    public class CentreFrequency
    implements TreeNode {
        private final int freqOffset;

        public CentreFrequency(int freqOffset) {
            this.freqOffset = freqOffset;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            long frequencyAsLong = Utils.getLong(FrequencyListDescriptor.this.privateData, this.freqOffset, 4, -1L);
            switch (FrequencyListDescriptor.this.codingType) {
                case 1: {
                    return new DefaultMutableTreeNode(new KVP("centre_frequency", frequencyAsLong, Descriptor.formatSatelliteFrequency(Utils.getBCD(FrequencyListDescriptor.this.privateData, this.freqOffset * 2, 8))));
                }
                case 2: {
                    return new DefaultMutableTreeNode(new KVP("centre_frequency", frequencyAsLong, Descriptor.formatCableFrequency(Utils.getBCD(FrequencyListDescriptor.this.privateData, this.freqOffset * 2, 8))));
                }
                case 3: {
                    return new DefaultMutableTreeNode(new KVP("centre_frequency", frequencyAsLong, Descriptor.formatTerrestrialFrequency(frequencyAsLong)));
                }
            }
            return new DefaultMutableTreeNode(new KVP("centre_frequency", frequencyAsLong, null));
        }
    }
}

