/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class HEVCVideoDescriptor
extends Descriptor {
    private final int profile_space;
    private final int tier_flag;
    private final int profile_idc;
    private final long profile_compatibility_indication;
    private final int progressive_source_flag;
    private final int interlaced_source_flag;
    private final int non_packed_constraint_flag;
    private final int frame_only_constraint_flag;
    private final long copied_44bits;
    private final int level_idc;
    private final int temporal_layer_subset_flag;
    private final int HEVC_still_present_flag;
    private final int HEVC_24hr_picture_present_flag;
    private final int sub_pic_hrd_params_not_present_flag;
    private final int reserved1;
    private final int HDR_WCG_idc;
    private int temporal_id_min;
    private int reserved2;
    private int temporal_id_max;
    private int reserved3;
    private static final String[] HDR_WCG_idc_Strings = new String[]{"SDR", "WCG only", "both WCG and HDR", "no indication"};

    public HEVCVideoDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.profile_space = Utils.getInt(b, offset + 2, 1, 192) >>> 6;
        this.tier_flag = Utils.getInt(b, offset + 2, 1, 32) >>> 5;
        this.profile_idc = Utils.getInt(b, offset + 2, 1, 31);
        this.profile_compatibility_indication = Utils.getLong(b, offset + 3, 4, -1L);
        this.progressive_source_flag = Utils.getInt(b, offset + 7, 1, 128) >>> 7;
        this.interlaced_source_flag = Utils.getInt(b, offset + 7, 1, 64) >>> 6;
        this.non_packed_constraint_flag = Utils.getInt(b, offset + 7, 1, 32) >>> 5;
        this.frame_only_constraint_flag = Utils.getInt(b, offset + 7, 1, 16) >>> 4;
        this.copied_44bits = Utils.getLong(b, offset + 7, 6, 0xFFFFFFFFFFFL);
        this.level_idc = Utils.getInt(b, offset + 13, 1, 255);
        this.temporal_layer_subset_flag = Utils.getInt(b, offset + 14, 1, 128) >>> 7;
        this.HEVC_still_present_flag = Utils.getInt(b, offset + 14, 1, 64) >>> 6;
        this.HEVC_24hr_picture_present_flag = Utils.getInt(b, offset + 14, 1, 32) >>> 5;
        this.sub_pic_hrd_params_not_present_flag = Utils.getInt(b, offset + 14, 1, 16) >>> 4;
        this.reserved1 = Utils.getInt(b, offset + 14, 1, 12) >>> 2;
        this.HDR_WCG_idc = Utils.getInt(b, offset + 14, 1, 3);
        if (this.temporal_layer_subset_flag == 1) {
            this.temporal_id_min = Utils.getInt(b, offset + 15, 1, 224) >>> 5;
            this.reserved2 = Utils.getInt(b, offset + 15, 1, 31);
            this.temporal_id_max = Utils.getInt(b, offset + 16, 1, 224) >>> 5;
            this.reserved3 = Utils.getInt(b, offset + 16, 1, 31);
        }
    }

    public static final String getHdrWcgIdcString(int value) {
        if (value < 0 || value > 3) {
            throw new IllegalArgumentException("Invalid value in getHdrWcgIdcString:" + value);
        }
        return HDR_WCG_idc_Strings[value];
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("profile_space", this.profile_space, null)));
        t.add(new DefaultMutableTreeNode(new KVP("tier_flag", this.tier_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("profile_idc", this.profile_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("profile_compatibility_indication", this.profile_compatibility_indication, null)));
        t.add(new DefaultMutableTreeNode(new KVP("progressive_source_flag", this.progressive_source_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("interlaced_source_flag", this.interlaced_source_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("non_packed_constraint_flag", this.non_packed_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_only_constraint_flag", this.frame_only_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("copied_44bits", this.copied_44bits, null)));
        t.add(new DefaultMutableTreeNode(new KVP("level_idc", this.level_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("temporal_layer_subset_flag", this.temporal_layer_subset_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("HEVC_still_present_flag", this.HEVC_still_present_flag, this.HEVC_still_present_flag == 1 ? "HEVC video stream or the HEVC highest temporal sub-layer representation may include HEVC still pictures" : "the associated HEVC video stream shall not contain HEVC still pictures")));
        t.add(new DefaultMutableTreeNode(new KVP("HEVC_24hr_picture_present_flag", this.HEVC_24hr_picture_present_flag, this.HEVC_24hr_picture_present_flag == 1 ? "HEVC video stream or the HEVC highest temporal sub-layer representation may contain HEVC 24-hour pictures" : "the associated HEVC video stream shall not contain HEVC 24-hour pictures")));
        t.add(new DefaultMutableTreeNode(new KVP("sub_pic_hrd_params_not_present_flag", this.sub_pic_hrd_params_not_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved1", this.reserved1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("HDR_WCG_idc", this.HDR_WCG_idc, HEVCVideoDescriptor.getHdrWcgIdcString(this.HDR_WCG_idc))));
        if (this.temporal_layer_subset_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("temporal_id_min", this.temporal_id_min, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved2", this.reserved2, null)));
            t.add(new DefaultMutableTreeNode(new KVP("temporal_id_max", this.temporal_id_max, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved3", this.reserved3, null)));
        }
        return t;
    }
}

