/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class HierarchyDescriptor
extends Descriptor {
    private int reserved1;
    private int hierarchy_type;
    private int reserved2;
    private int hierarchy_layer_index;
    private int reserved3;
    private int hierarchy_embedded_layer_index;
    private int reserved4;
    private int hierarchy_channel;

    public HierarchyDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.reserved1 = Utils.getInt(b, offset + 2, 1, 240) >> 4;
        this.hierarchy_type = Utils.getInt(b, offset + 2, 1, 15);
        this.reserved2 = Utils.getInt(b, offset + 3, 1, 176) >> 6;
        this.hierarchy_layer_index = Utils.getInt(b, offset + 3, 1, 63);
        this.reserved3 = Utils.getInt(b, offset + 4, 1, 176) >> 6;
        this.hierarchy_embedded_layer_index = Utils.getInt(b, offset + 4, 1, 63);
        this.reserved4 = Utils.getInt(b, offset + 5, 1, 176) >> 6;
        this.hierarchy_channel = Utils.getInt(b, offset + 5, 1, 63);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("hierarchy_type", this.hierarchy_type, HierarchyDescriptor.getHierarchyTypeString(this.hierarchy_type))));
        t.add(new DefaultMutableTreeNode(new KVP("hierarchy_layer_index", this.hierarchy_layer_index, null)));
        t.add(new DefaultMutableTreeNode(new KVP("hierarchy_embedded_layer_index", this.hierarchy_embedded_layer_index, null)));
        t.add(new DefaultMutableTreeNode(new KVP("hierarchy_channel", this.hierarchy_channel, null)));
        return t;
    }

    public static String getHierarchyTypeString(int hierarchyType) {
        switch (hierarchyType) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 Spatial Scalability";
            }
            case 2: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 SNR Scalability";
            }
            case 3: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 Temporal Scalability";
            }
            case 4: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 Data partitioning";
            }
            case 5: {
                return "ISO/IEC 13818-3 Extension bitstream";
            }
            case 6: {
                return "ITU-T Rec.H222.0 | ISO/IEC 13818-1 Private Stream";
            }
            case 7: {
                return "ITU-T Rec. H.262 | ISO/IEC 13818-2 Multi-view Profile";
            }
            case 15: {
                return "Base layer";
            }
        }
        return "Reserved";
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public int getHierarchy_type() {
        return this.hierarchy_type;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getHierarchy_layer_index() {
        return this.hierarchy_layer_index;
    }

    public int getReserved3() {
        return this.reserved3;
    }

    public int getHierarchy_embedded_layer_index() {
        return this.hierarchy_embedded_layer_index;
    }

    public int getReserved4() {
        return this.reserved4;
    }

    public int getHierarchy_channel() {
        return this.hierarchy_channel;
    }
}

