/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ISO639LanguageDescriptor
extends Descriptor {
    private final List<Language> languageList = new ArrayList<Language>();

    public ISO639LanguageDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 4) {
            String languageCode = Utils.getISO8859_1String(b, offset + t + 2, 3);
            int audio = Utils.getInt(b, offset + t + 5, 1, 255);
            Language s = new Language(languageCode, audio);
            this.languageList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Language language : this.languageList) {
            buf.append(language.toString());
        }
        return buf.toString();
    }

    public static String getAudioTypeString(int audio) {
        switch (audio) {
            case 0: {
                return "Undefined";
            }
            case 1: {
                return "Clean effects";
            }
            case 2: {
                return "Hearing impaired";
            }
            case 3: {
                return "Visual impaired commentary";
            }
        }
        if (audio >= 4 && audio <= 127) {
            return "User Private";
        }
        return "Reserved";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.languageList, modus, "language_list");
        return t;
    }

    public List<Language> getLanguageList() {
        return this.languageList;
    }

    public static class Language
    implements TreeNode {
        private final String iso639LanguageCode;
        private final int audioType;

        public Language(String lCode, int audioT) {
            this.iso639LanguageCode = lCode;
            this.audioType = audioT;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("language"));
            s.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
            s.add(new DefaultMutableTreeNode(new KVP("audio_type", this.audioType, ISO639LanguageDescriptor.getAudioTypeString(this.audioType))));
            return s;
        }

        public int getAudioType() {
            return this.audioType;
        }

        public String getIso639LanguageCode() {
            return this.iso639LanguageCode;
        }

        public String toString() {
            return "code:'" + this.iso639LanguageCode + "', audio:" + this.audioType;
        }
    }
}

