/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class LinkageDescriptor
extends Descriptor {
    private static final Logger logger = Logger.getLogger(LinkageDescriptor.class.getName());
    private List<OUIEntry> ouiList = new ArrayList<OUIEntry>();
    private List<Platform> platformList = new ArrayList<Platform>();
    private List<NordigBootLoader> bootLoaderList = new ArrayList<NordigBootLoader>();
    private List<BrandHomeTransponder> m7BrandHomeTransponderList = new ArrayList<BrandHomeTransponder>();
    private int transportStreamId;
    private int originalNetworkId;
    private final int serviceId;
    private final int linkageType;
    private int hand_over_type;
    private int origin_type;
    private int network_id;
    private int initial_service_id;
    private int OUI_data_length;
    private int tableType;
    private byte[] privateDataByte;
    private int platformIdDataLength;
    private int bouquetID;
    private int target_event_id;
    private int target_listed;
    private int event_simulcast;
    private int reserved;
    private int font_count;
    private List<FontInfo> fontList = new ArrayList<FontInfo>();
    private int m7_code;

    public LinkageDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.transportStreamId = Utils.getInt(b, 2, 2, 65535);
        this.originalNetworkId = Utils.getInt(b, 4, 2, 65535);
        this.serviceId = Utils.getInt(b, 6, 2, 65535);
        this.linkageType = Utils.getInt(b, 8, 1, 255);
        if (this.linkageType == 8) {
            int r = 0;
            this.hand_over_type = Utils.getInt(b, 9, 1, 240) >>> 4;
            this.origin_type = Utils.getInt(b, 9, 1, 1);
            if (this.hand_over_type == 1 || this.hand_over_type == 2 || this.hand_over_type == 3) {
                this.network_id = Utils.getInt(b, 10, 2, 65535);
                r += 2;
            }
            if (this.origin_type == 0) {
                this.initial_service_id = Utils.getInt(b, 10 + r, 2, 65535);
                r += 2;
            }
            this.privateDataByte = Arrays.copyOfRange(b, 10 + r, this.descriptorLength + 2);
        } else if (this.linkageType == 9) {
            this.OUI_data_length = Utils.getInt(b, 9, 1, 255);
            int r = 0;
            while (r < this.OUI_data_length) {
                int oui = Utils.getInt(b, 10 + r, 3, 0xFFFFFF);
                int selectorLength = Utils.getInt(b, r + 13, 1, 255);
                byte[] selector_byte = Arrays.copyOfRange(b, r + 14, r + 14 + selectorLength);
                OUIEntry ouiEntry = new OUIEntry(oui, selectorLength, selector_byte);
                this.ouiList.add(ouiEntry);
                r = r + 4 + selectorLength;
            }
            this.privateDataByte = Arrays.copyOfRange(b, 10 + r, this.descriptorLength + 2);
        } else if (this.linkageType == 10) {
            this.tableType = Utils.getInt(b, 9, 1, 255);
            this.privateDataByte = Arrays.copyOfRange(b, 10, this.descriptorLength + 2);
        } else if (this.linkageType == 11) {
            int r;
            int t;
            this.platformIdDataLength = Utils.getInt(b, 9, 1, 255);
            for (r = 0; r < this.platformIdDataLength; r += t + 4) {
                DVBString platformName;
                int platform_id = Utils.getInt(b, 10 + r, 3, 0xFFFFFF);
                Platform p = new Platform(platform_id);
                this.platformList.add(p);
                int platform_name_loop_length = Utils.getInt(b, r + 13, 1, 255);
                for (t = 0; t < platform_name_loop_length; t += 4 + platformName.getLength()) {
                    String languageCode = Utils.getISO8859_1String(b, r + t + 14, 3);
                    platformName = new DVBString(b, r + t + 17);
                    PlatformName pName = new PlatformName(languageCode, platformName);
                    p.addPlatformName(pName);
                }
            }
            this.privateDataByte = Arrays.copyOfRange(b, 10 + r, this.descriptorLength + 2);
        } else if (this.linkageType == 12) {
            this.tableType = Utils.getInt(b, 9, 1, 255);
            if (this.tableType == 2) {
                this.bouquetID = Utils.getInt(b, 10, 2, 65535);
                this.privateDataByte = Arrays.copyOfRange(b, 12, this.descriptorLength + 2);
            } else {
                this.privateDataByte = Arrays.copyOfRange(b, 10, this.descriptorLength + 2);
            }
        } else if (this.linkageType == 13) {
            this.target_event_id = Utils.getInt(b, 9, 2, 65535);
            this.target_listed = Utils.getInt(b, 11, 1, 128) >> 7;
            this.event_simulcast = Utils.getInt(b, 11, 1, 64) >> 6;
            this.reserved = Utils.getInt(b, 11, 1, 63);
            this.privateDataByte = Arrays.copyOfRange(b, 12, this.descriptorLength + 2);
        } else if (this.linkageType >= 14 && this.linkageType <= 31) {
            logger.info("extended event linkage not implemented");
        } else if (this.linkageType == 32) {
            this.font_count = Utils.getInt(b, 9, 1, 255);
            for (int i = 0; i < this.font_count; ++i) {
                FontInfo font = new FontInfo(this, Utils.getInt(b, 10 + i, 1, 255));
                this.fontList.add(font);
            }
            this.privateDataByte = Arrays.copyOfRange(b, 10 + this.font_count, this.descriptorLength + 2);
        } else if (this.linkageType == 129) {
            int s = 9;
            while (s + 17 <= this.descriptorLength) {
                int manufacturer_id = Utils.getInt(b, s, 2, 65535);
                byte[] version_id = Arrays.copyOfRange(b, s + 2, s + 10);
                long private_id = Utils.getLong(b, s + 10, 4, -1L);
                byte[] start_time = Arrays.copyOfRange(b, s + 14, s + 19);
                NordigBootLoader nordigBootLoader = new NordigBootLoader(manufacturer_id, version_id, private_id, start_time);
                this.bootLoaderList.add(nordigBootLoader);
                s += 19;
            }
            this.privateDataByte = Arrays.copyOfRange(b, s, this.descriptorLength + 2);
        } else if ((this.linkageType == 136 || this.linkageType == 137 || this.linkageType == 138) && PreferencesManager.isEnableM7Fastscan()) {
            this.m7_code = Utils.getInt(b, 9, 2, 65535);
            int s = 11;
            while (s + 9 <= this.descriptorLength) {
                int operator_network_id = Utils.getInt(b, s, 2, 65535);
                int operator_sublist_id = Utils.getInt(b, s + 2, 1, 255);
                int home_transport_stream_id = Utils.getInt(b, s + 3, 2, 65535);
                int home_original_network_id = Utils.getInt(b, s + 5, 2, 65535);
                int homebckp_transport_stream_id = Utils.getInt(b, s + 7, 2, 65535);
                int homebckp_original_network_id = Utils.getInt(b, s + 9, 2, 65535);
                int fst_pid = Utils.getInt(b, s + 11, 2, 65535);
                int fst_version_number = Utils.getInt(b, s + 13, 1, 248) >>> 3;
                int reserved = Utils.getInt(b, s + 13, 1, 7);
                BrandHomeTransponder brandHomeTransponder = new BrandHomeTransponder(operator_network_id, operator_sublist_id, home_transport_stream_id, home_original_network_id, homebckp_transport_stream_id, homebckp_original_network_id, fst_pid, fst_version_number, reserved);
                this.m7BrandHomeTransponderList.add(brandHomeTransponder);
                s += 14;
            }
            this.privateDataByte = Arrays.copyOfRange(b, s, this.descriptorLength + 2);
        } else if (this.linkageType == 141 && PreferencesManager.isEnableM7Fastscan()) {
            this.m7_code = Utils.getInt(b, 9, 2, 65535);
            this.reserved = Utils.getInt(b, 11, 1, 255);
            this.privateDataByte = Arrays.copyOfRange(b, 12, this.descriptorLength + 2);
        } else if (this.linkageType <= 7) {
            this.privateDataByte = Arrays.copyOfRange(b, 9, this.descriptorLength + 2);
        } else {
            logger.log(Level.INFO, "LinkageDescriptor, not implemented linkageType: " + this.linkageType + "(" + LinkageDescriptor.getLinkageTypeString(this.linkageType) + "), called from:" + String.valueOf(parent));
            this.privateDataByte = Arrays.copyOfRange(b, 9, this.descriptorLength + 2);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "transportStreamId=" + this.transportStreamId;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.add(new KVP("transport_stream_id", this.transportStreamId));
        t.add(new KVP("original_network_id", this.originalNetworkId).setDescription(Utils.getOriginalNetworkIDString(this.originalNetworkId)));
        t.add(new KVP("service_id", this.serviceId).setDescription(this.parentTableSection.getParentPID().getParentTransportStream().getPsi().getSdt().getServiceName(this.originalNetworkId, this.transportStreamId, this.serviceId)));
        t.add(new KVP("linkage_type", this.linkageType).setDescription(LinkageDescriptor.getLinkageTypeString(this.linkageType)));
        if (this.linkageType == 8) {
            t.add(new KVP("hand-over_type", this.hand_over_type).setDescription(LinkageDescriptor.getHandOverString(this.hand_over_type)));
            t.add(new KVP("origin_type", this.origin_type).setDescription(LinkageDescriptor.getOriginTypeString(this.origin_type)));
            if (this.hand_over_type == 1 || this.hand_over_type == 2 || this.hand_over_type == 3) {
                t.add(new KVP("network_id", this.network_id).setDescription(this.getParentPID().getParentTransportStream().getPsi().getNit().getNetworkName(this.network_id)));
            }
            if (this.origin_type == 0) {
                t.add(new KVP("initial_service_id", this.initial_service_id));
            }
        } else if (this.linkageType == 9) {
            Utils.addListJTree(t, this.ouiList, modus, "Systems Software Update");
        } else if (this.linkageType == 10) {
            t.add(new KVP("table_type", this.tableType).setDescription(LinkageDescriptor.getTableTypeString(this.tableType)));
        } else if (this.linkageType == 11) {
            Utils.addListJTree(t, this.platformList, modus, "platform_list");
        } else if (this.linkageType == 12) {
            t.add(new KVP("table_type", this.tableType).setDescription(LinkageDescriptor.getTableTypeString(this.tableType)));
            if (this.tableType == 2) {
                t.add(new KVP("bouquet_id", this.bouquetID));
            }
        } else if (this.linkageType == 13) {
            t.add(new KVP("target_event_id", this.target_event_id));
            t.add(new KVP("target_listed", this.target_listed).setDescription(this.target_listed == 1 ? "service shall be included in SDT" : "service may not be included in SDT"));
            t.add(new KVP("event_simulcast", this.event_simulcast).setDescription(this.event_simulcast == 1 ? "target and source are being simulcast" : "events are offset in time"));
            t.add(new KVP("reserved", this.reserved));
        } else if (this.linkageType >= 14 && this.linkageType <= 31) {
            t.add(GuiUtils.getNotImplementedKVP("extended event linkage"));
        } else if (this.linkageType == 32) {
            t.add(new KVP("font_count", this.font_count));
            Utils.addListJTree(t, this.fontList, modus, "(downloadable fonts");
            t.add(new KVP("reserved_zero_future_use", this.privateDataByte));
        } else if (this.linkageType == 129) {
            Utils.addListJTree(t, this.bootLoaderList, modus, "Nordig BootLoader");
        } else if ((this.linkageType == 136 || this.linkageType == 137 || this.linkageType == 144) && PreferencesManager.isEnableM7Fastscan()) {
            t.add(new KVP("m7_code", this.m7_code).setDescription("should contain values from 0x7701 to 0x77FF"));
            Utils.addListJTree(t, this.m7BrandHomeTransponderList, modus, "M7 Brand-HomeTransponderList");
        } else if (this.linkageType == 141 && PreferencesManager.isEnableM7Fastscan()) {
            t.add(new KVP("m7_code", this.m7_code).setDescription("should contain values from 0x7701 to 0x77FF (service_id == ONT_PID)"));
            t.add(new KVP("reserved", this.reserved));
        } else {
            t.add(new KVP("private_data_byte", this.privateDataByte).setDescription("unimplmented linkage type"));
        }
        return t;
    }

    public int getOriginalNetworkId() {
        return this.originalNetworkId;
    }

    public int getTransportStreamId() {
        return this.transportStreamId;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }

    public static String getLinkageTypeString(int linkageType) {
        switch (linkageType) {
            case 0: {
                return "reserved for future use";
            }
            case 1: {
                return "information service";
            }
            case 2: {
                return "EPG service";
            }
            case 3: {
                return "CA replacement service";
            }
            case 4: {
                return "TS containing complete Network/Bouquet SI";
            }
            case 5: {
                return "service replacement service";
            }
            case 6: {
                return "data broadcast service";
            }
            case 7: {
                return "RCS Map";
            }
            case 8: {
                return "mobile hand-over";
            }
            case 9: {
                return "System Software Update Service";
            }
            case 10: {
                return "TS containing SSU BAT or NIT";
            }
            case 11: {
                return "IP/MAC Notification Service";
            }
            case 12: {
                return "TS containing INT BAT or NIT";
            }
            case 13: {
                return "event linkage";
            }
            case 32: {
                return "downloadable font info linkage";
            }
            case 33: {
                return "Native IP bootstrap MPE stream";
            }
            case 129: {
                return "user defined: (linkage to NorDig bootloader)";
            }
            case 130: {
                return "user defined: (NorDig Simulcast replacement service/linkage to Ziggo software update)";
            }
            case 136: 
            case 137: 
            case 138: {
                return "user defined: (M7 Fastscan Home TP location descriptor)";
            }
            case 141: {
                return "user defined: (M7 Fastscan ONT location location descriptor)";
            }
            case 144: {
                return "user defined: SES SGT HD+ LCN";
            }
            case 145: {
                return "user defined: SES SGT Austria LCN";
            }
            case 147: {
                return "user defined: SES SGT International LCN";
            }
            case 160: {
                return "user defined: link to OpenTV VOD service";
            }
            case 162: {
                return "user defined: SES SGT White Label Platform LCN";
            }
            case 166: {
                return "user defined: link to OpenTV ITV service (YOUSEE)";
            }
            case 167: {
                return "user defined: link to WEB service (YOUSEE)";
            }
            case 255: {
                return "reserved for future use";
            }
        }
        if (14 <= linkageType && linkageType <= 31) {
            return "extended event linkage";
        }
        if (33 <= linkageType && linkageType <= 127) {
            return "reserved for future use";
        }
        if (128 <= linkageType && linkageType <= 254) {
            return "user defined";
        }
        return "Illegal value";
    }

    public static String getTableTypeString(int tableType) {
        switch (tableType) {
            case 0: {
                return "not defined";
            }
            case 1: {
                return "NIT";
            }
            case 2: {
                return "BAT";
            }
        }
        return "reserved for future use";
    }

    public static String getHandOverString(int handOver) {
        switch (handOver) {
            case 0: {
                return "reserved for future use";
            }
            case 1: {
                return "DVB hand-over to an identical service in a neighbouring country";
            }
            case 2: {
                return "DVB hand-over to a local variation of the same service";
            }
            case 3: {
                return "DVB hand-over to an associated service";
            }
        }
        return "reserved for future use";
    }

    public static String getOriginTypeString(int originType) {
        switch (originType) {
            case 0: {
                return "NIT";
            }
            case 1: {
                return "SDT";
            }
        }
        return "illegal value";
    }

    public int getBouquetID() {
        return this.bouquetID;
    }

    public int getHand_over_type() {
        return this.hand_over_type;
    }

    public int getInitial_service_id() {
        return this.initial_service_id;
    }

    public int getLinkageType() {
        return this.linkageType;
    }

    public int getNetwork_id() {
        return this.network_id;
    }

    public int getOrigin_type() {
        return this.origin_type;
    }

    public int getOUI_data_length() {
        return this.OUI_data_length;
    }

    public List<OUIEntry> getOuiList() {
        return this.ouiList;
    }

    public int getPlatformIdDataLength() {
        return this.platformIdDataLength;
    }

    public List<Platform> getPlatformList() {
        return this.platformList;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public int getTableType() {
        return this.tableType;
    }

    public int getM7_code() {
        return this.m7_code;
    }

    public List<BrandHomeTransponder> getM7BrandHomeTransponderList() {
        return this.m7BrandHomeTransponderList;
    }

    public record OUIEntry(int oui, int selectorLength, byte[] selectorByte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("OUI");
            s.add(new KVP("oui", this.oui).setDescription(Utils.getOUIString(this.oui)));
            s.add(new KVP("selector_length", this.selectorLength));
            s.add(new KVP("selector_bytes", this.selectorByte));
            return s;
        }
    }

    public static class Platform
    implements TreeNode {
        private final int platformId;
        private List<PlatformName> platformNameList = new ArrayList<PlatformName>();

        public Platform(int pID) {
            this.platformId = pID;
        }

        public void addPlatformName(PlatformName s) {
            this.platformNameList.add(s);
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("platforms");
            s.add(new KVP("platform_id", this.platformId).setDescription(Utils.getPlatformIDString(this.platformId)));
            Utils.addListJTree(s, this.platformNameList, modus, "platform_name_loop");
            return s;
        }
    }

    public record PlatformName(String iso639LanguageCode, DVBString platformName) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("platform_name");
            s.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            s.add(new KVP("platform_name", this.platformName));
            return s;
        }
    }

    public class FontInfo
    implements TreeNode {
        private int essential_font_download_flag;
        private int font_id;

        private FontInfo(LinkageDescriptor this$0, int fontInfo) {
            this.essential_font_download_flag = (fontInfo & 0x80) >> 7;
            this.font_id = fontInfo & 0x7F;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Donwloadable Font");
            s.add(new KVP("essential_font_download_flag", this.essential_font_download_flag).setDescription(this.essential_font_download_flag == 1 ? "font is required to present these subtitles" : "font is a supplementary font"));
            s.add(new KVP("font_id", this.font_id));
            return s;
        }
    }

    public record NordigBootLoader(int manufacturer_id, byte[] version_id, long private_id, byte[] start_time) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("bootloader");
            s.add(new KVP("manufacturer_id", this.manufacturer_id));
            s.add(new KVP("version_id", this.version_id));
            s.add(new KVP("private_id", this.private_id));
            s.add(new KVP("start_time", this.start_time).setDescription(Utils.getUTCFormattedString(this.start_time)));
            return s;
        }
    }

    public record BrandHomeTransponder(int operator_network_id, int operator_sublist_id, int home_transport_stream_id, int home_original_network_id, int homebckp_transport_stream_id, int homebckp_original_network_id, int fst_pid, int fst_version_number, int reserved) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("M7BrandHomeTransponder");
            s.add(new KVP("operator_network_id", this.operator_network_id));
            s.add(new KVP("operator_sublist_id", this.operator_sublist_id));
            s.add(new KVP("home_transport_stream_id", this.home_transport_stream_id));
            s.add(new KVP("home_original_network_id", this.home_original_network_id));
            s.add(new KVP("homebckp_transport_stream_id", this.homebckp_transport_stream_id));
            s.add(new KVP("homebckp_original_network_id", this.homebckp_original_network_id));
            s.add(new KVP("fst_pid", this.fst_pid));
            s.add(new KVP("FST_version_number", this.fst_version_number));
            s.add(new KVP("reserved", this.reserved));
            return s;
        }
    }
}

