/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MosaicDescriptor
extends Descriptor {
    private List<LogicalCell> logicalCellList = new ArrayList<LogicalCell>();
    private int mosaicEntryPoint = 0;
    private int numberOfHorizontalElementaryCells = 0;
    private int numberOfVerticalElementaryCells = 0;

    public MosaicDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.mosaicEntryPoint = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.numberOfHorizontalElementaryCells = Utils.getInt(b, offset + 2, 1, 112) >> 4;
        this.numberOfVerticalElementaryCells = Utils.getInt(b, offset + 2, 1, 7);
        int t = 1;
        while (t < this.descriptorLength) {
            int logical_cell_id = Utils.getInt(b, offset + t + 2, 1, 252) >> 2;
            int logical_cell_presentation_info = Utils.getInt(b, offset + t + 3, 1, 7);
            int elementary_cell_field_length = Utils.getInt(b, offset + t + 4, 1, 255);
            byte[] elementary_cell_ids = Utils.getBytes(b, offset + t + 5, elementary_cell_field_length);
            int cell_linkage_info = Utils.getInt(b, offset + t + 5 + elementary_cell_field_length, 1, 255);
            LogicalCell s = new LogicalCell(logical_cell_id, logical_cell_presentation_info, elementary_cell_field_length, elementary_cell_ids, cell_linkage_info);
            t = t + 4 + elementary_cell_field_length;
            if (cell_linkage_info == 1) {
                s.setBouquetId(Utils.getInt(b, offset + t + 2, 2, 65535));
                t += 2;
            }
            if (cell_linkage_info == 2) {
                s.setOriginalNetworkId(Utils.getInt(b, offset + t + 2, 2, 65535));
                s.setTransportStreamId(Utils.getInt(b, offset + t + 4, 2, 65535));
                s.setServiceId(Utils.getInt(b, offset + t + 6, 2, 65535));
                t += 6;
            }
            if (cell_linkage_info == 3) {
                s.setOriginalNetworkId(Utils.getInt(b, offset + t + 2, 2, 65535));
                s.setTransportStreamId(Utils.getInt(b, offset + t + 4, 2, 65535));
                s.setServiceId(Utils.getInt(b, offset + t + 6, 2, 65535));
                t += 6;
            }
            if (cell_linkage_info == 4) {
                s.setOriginalNetworkId(Utils.getInt(b, offset + t + 2, 2, 65535));
                s.setTransportStreamId(Utils.getInt(b, offset + t + 4, 2, 65535));
                s.setServiceId(Utils.getInt(b, offset + t + 6, 2, 65535));
                s.setEventId(Utils.getInt(b, offset + t + 8, 2, 65535));
                t += 8;
            }
            this.logicalCellList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (LogicalCell logicalCell : this.logicalCellList) {
            buf.append(logicalCell.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("mosaic_entry_point", this.mosaicEntryPoint, this.mosaicEntryPoint == 1 ? "entry point" : "sub tree")));
        t.add(new DefaultMutableTreeNode(new KVP("number_of_horizontal_elementary_cells", this.numberOfHorizontalElementaryCells, MosaicDescriptor.getNumberOfElementaryCells(this.numberOfHorizontalElementaryCells))));
        t.add(new DefaultMutableTreeNode(new KVP("number_of_vertical_elementary_cells", this.numberOfVerticalElementaryCells, MosaicDescriptor.getNumberOfElementaryCells(this.numberOfVerticalElementaryCells))));
        Utils.addListJTree(t, this.logicalCellList, modus, "logical_cell_list");
        return t;
    }

    public static String getNumberOfElementaryCells(int cells) {
        switch (cells) {
            case 0: {
                return "one cell";
            }
            case 1: {
                return "two cells";
            }
            case 2: {
                return "three cells";
            }
            case 3: {
                return "four cells";
            }
            case 4: {
                return "five cells";
            }
            case 5: {
                return "six cells";
            }
            case 6: {
                return "seven cells";
            }
            case 7: {
                return "eight cells";
            }
        }
        return "illegal value";
    }

    public static String getCodingOfLogicalCellPresentationInfo(int info) {
        switch (info) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "video";
            }
            case 2: {
                return "still picture";
            }
            case 3: {
                return "graphics/text";
            }
        }
        return "reserved for future use";
    }

    public static String getCodingOfCellLinkageInfo(int info) {
        switch (info) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "bouquet related";
            }
            case 2: {
                return "service related";
            }
            case 3: {
                return "other mosaic related";
            }
            case 4: {
                return "event related";
            }
        }
        return "reserved for future use";
    }

    public class LogicalCell
    implements TreeNode {
        private int logicalCellId;
        private int logicalCellPresentationInfo;
        private int elementaryCellFieldLength;
        private byte[] elementaryCellIds;
        private int cellLinkageInfo;
        private int bouquetId;
        private int originalNetworkId;
        private int transportStreamId;
        private int serviceId;
        private int eventId;

        public LogicalCell(int logical_cell_id, int logical_cell_presentation_info, int elementary_cell_field_length, byte[] elementary_cell_ids, int cell_linkage_info) {
            this.logicalCellId = logical_cell_id;
            this.logicalCellPresentationInfo = logical_cell_presentation_info;
            this.elementaryCellFieldLength = elementary_cell_field_length;
            this.elementaryCellIds = elementary_cell_ids;
            this.cellLinkageInfo = cell_linkage_info;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("logical_cell"));
            s.add(new DefaultMutableTreeNode(new KVP("logical_cell_id", this.logicalCellId, null)));
            s.add(new DefaultMutableTreeNode(new KVP("logical_cell_presentation_info", this.logicalCellPresentationInfo, MosaicDescriptor.getCodingOfLogicalCellPresentationInfo(this.logicalCellPresentationInfo))));
            s.add(new DefaultMutableTreeNode(new KVP("elementary_cell_field_length", this.elementaryCellFieldLength, null)));
            s.add(new DefaultMutableTreeNode(new KVP("elementary_cell_ids", this.elementaryCellIds, null)));
            s.add(new DefaultMutableTreeNode(new KVP("cell_linkage_info", this.cellLinkageInfo, MosaicDescriptor.getCodingOfCellLinkageInfo(this.cellLinkageInfo))));
            if (this.cellLinkageInfo == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("bouquet_id", this.bouquetId, null)));
            }
            if (this.cellLinkageInfo == 2) {
                s.add(new DefaultMutableTreeNode(new KVP("original_network_id", this.originalNetworkId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("transport_stream_id", this.transportStreamId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceId, MosaicDescriptor.this.parentTableSection.getParentTransportStream().getPsi().getSdt().getServiceName(this.originalNetworkId, this.transportStreamId, this.serviceId))));
            }
            if (this.cellLinkageInfo == 3) {
                s.add(new DefaultMutableTreeNode(new KVP("original_network_id", this.originalNetworkId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("transport_stream_id", this.transportStreamId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceId, MosaicDescriptor.this.parentTableSection.getParentTransportStream().getPsi().getSdt().getServiceName(this.originalNetworkId, this.transportStreamId, this.serviceId))));
            }
            if (this.cellLinkageInfo == 4) {
                s.add(new DefaultMutableTreeNode(new KVP("original_network_id", this.originalNetworkId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("transport_stream_id", this.transportStreamId, null)));
                s.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceId, MosaicDescriptor.this.parentTableSection.getParentTransportStream().getPsi().getSdt().getServiceName(this.originalNetworkId, this.transportStreamId, this.serviceId))));
                s.add(new DefaultMutableTreeNode(new KVP("event", this.eventId, null)));
            }
            return s;
        }

        public int getBouquetId() {
            return this.bouquetId;
        }

        public void setBouquetId(int bouquetId) {
            this.bouquetId = bouquetId;
        }

        public int getEventId() {
            return this.eventId;
        }

        public void setEventId(int eventId) {
            this.eventId = eventId;
        }

        public int getOriginalNetworkId() {
            return this.originalNetworkId;
        }

        public void setOriginalNetworkId(int originalNetworkId) {
            this.originalNetworkId = originalNetworkId;
        }

        public int getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(int serviceId) {
            this.serviceId = serviceId;
        }

        public int getTransportStreamId() {
            return this.transportStreamId;
        }

        public void setTransportStreamId(int transportStreamId) {
            this.transportStreamId = transportStreamId;
        }
    }
}

