/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MultilingualBouquetNameDescriptor
extends Descriptor {
    private final List<BouquetName> bouquetNameList = new ArrayList<BouquetName>();

    public MultilingualBouquetNameDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int bouquet_name_length;
        for (int t = 2; t < this.descriptorLength + 2; t += 4 + bouquet_name_length) {
            String languageCode = Utils.getISO8859_1String(b, t, 3);
            bouquet_name_length = Utils.getInt(b, t + 3, 1, 255);
            DVBString bouquet_name = new DVBString(b, t + 3);
            BouquetName s = new BouquetName(languageCode, bouquet_name);
            this.bouquetNameList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (BouquetName serviceName : this.bouquetNameList) {
            buf.append(serviceName.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.bouquetNameList, modus, "bouquet_name_list");
        return t;
    }

    public List<BouquetName> getBouquetNameList() {
        return this.bouquetNameList;
    }

    public record BouquetName(String iso639LanguageCode, DVBString bouquet_name) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("bouquet_name");
            s.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            s.add(new KVP("network_name", this.bouquet_name));
            return s;
        }
    }
}

