/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MultilingualNetworkNameDescriptor
extends Descriptor {
    private final List<NetworkName> networkNameList = new ArrayList<NetworkName>();

    public MultilingualNetworkNameDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int network_name_length;
        for (int t = 2; t < this.descriptorLength + 2; t += 4 + network_name_length) {
            String languageCode = Utils.getISO8859_1String(b, t, 3);
            network_name_length = Utils.getInt(b, t + 3, 1, 255);
            DVBString network_name = new DVBString(b, t + 3);
            NetworkName s = new NetworkName(languageCode, network_name);
            this.networkNameList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (NetworkName serviceName : this.networkNameList) {
            buf.append(serviceName.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.networkNameList, modus, "network_name_list");
        return t;
    }

    public List<NetworkName> getNetworkNameList() {
        return this.networkNameList;
    }

    public record NetworkName(String iso639LanguageCode, DVBString network_name) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("network_name");
            s.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            s.add(new KVP("network_name", this.network_name));
            return s;
        }
    }
}

