/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.ServiceIdentification;
import nl.digitalekabeltelevisie.util.Utils;

public class NVODReferenceDescriptor
extends Descriptor {
    private List<ServiceIdentification> servicesList = new ArrayList<ServiceIdentification>();

    public NVODReferenceDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 6) {
            int transportStreamId = Utils.getInt(b, offset + 2 + t, 2, 65535);
            int originalNetworkId = Utils.getInt(b, offset + 4 + t, 2, 65535);
            int serviceId = Utils.getInt(b, offset + 6 + t, 2, 65535);
            ServiceIdentification serviceIdentification = new ServiceIdentification(originalNetworkId, transportStreamId, serviceId);
            this.servicesList.add(serviceIdentification);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.servicesList, modus, "service_list");
        return t;
    }
}

