/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class PDCDescriptor
extends Descriptor {
    private final int day;
    private final int month;
    private final int hour;
    private final int minute;
    private final int programmeIdentificationLabel;

    public PDCDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.programmeIdentificationLabel = Utils.getInt(b, offset + 2, 3, 1048575);
        this.day = Utils.getInt(b, offset + 2, 2, 3968) >> 7;
        this.month = Utils.getInt(b, offset + 3, 1, 120) >> 3;
        this.hour = Utils.getInt(b, offset + 3, 2, 1984) >> 6;
        this.minute = Utils.getInt(b, offset + 4, 1, 63);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("programme_identification_label", this.programmeIdentificationLabel, "day:" + this.day + " month:" + this.month + " hour:" + this.hour + " minute:" + this.minute)));
        return t;
    }
}

