/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ParentalRatingDescriptor
extends Descriptor {
    private List<Rating> ratingList = new ArrayList<Rating>();

    public ParentalRatingDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 4) {
            String countryCode = Utils.getISO8859_1String(b, offset + t + 2, 3);
            int rating = Utils.getInt(b, offset + t + 5, 1, 255);
            Rating s = new Rating(this, countryCode, rating);
            this.ratingList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Rating rating : this.ratingList) {
            buf.append(rating.toString());
        }
        return buf.toString();
    }

    public static String getRatingTypeAge(int type) {
        if (type == 0) {
            return "undefined";
        }
        if (1 <= type && type <= 15) {
            return "minimum age = " + Integer.toString(type + 3);
        }
        return "defined by the broadcaster";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.ratingList, modus, "rating_list");
        return t;
    }

    public List<Rating> getRatingList() {
        return this.ratingList;
    }

    public class Rating
    implements TreeNode,
    Comparable<Rating> {
        private final String countryCode;
        private final int rating;

        public Rating(ParentalRatingDescriptor this$0, String countryCode, int rating) {
            this.countryCode = countryCode;
            this.rating = rating;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("rating"));
            s.add(new DefaultMutableTreeNode(new KVP("country_code", this.countryCode, null)));
            s.add(new DefaultMutableTreeNode(new KVP("rating", this.rating, ParentalRatingDescriptor.getRatingTypeAge(this.rating))));
            return s;
        }

        public String toString() {
            return ParentalRatingDescriptor.getRatingTypeAge(this.rating) + ", countryCode:" + this.countryCode;
        }

        public int getRating() {
            return this.rating;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public int compareTo(Rating o) {
            return Comparator.comparing(Rating::getRating).thenComparing(Rating::getCountryCode).compare(this, o);
        }
    }
}

