/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class RegistrationDescriptor
extends Descriptor {
    public static final byte[] SCTE_35 = new byte[]{67, 85, 69, 73};
    public static final byte[] AC_3 = new byte[]{65, 67, 45, 51};
    public static final byte[] SMPTE_2038 = new byte[]{86, 65, 78, 67};
    private final byte[] formatIdentifier;
    private final byte[] additionalIdentificationInfo;

    public RegistrationDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.formatIdentifier = Utils.getBytes(b, offset + 2, 4);
        this.additionalIdentificationInfo = Utils.getBytes(b, offset + 6, this.descriptorLength - 4);
    }

    @Override
    public String toString() {
        return super.toString() + "formatIdentifier=" + Utils.toHexString(this.formatIdentifier);
    }

    public byte[] getFormatIdentifier() {
        return this.formatIdentifier;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("format_identifier", this.formatIdentifier, null)));
        t.add(new DefaultMutableTreeNode(new KVP("additional_identification_info", this.additionalIdentificationInfo, null)));
        return t;
    }
}

