/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ServiceAvailabilityDescriptor
extends Descriptor {
    private final List<Cell> cellList = new ArrayList<Cell>();
    private int availability_flag;
    private int reserved;

    public ServiceAvailabilityDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.availability_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.reserved = Utils.getInt(b, offset + 2, 1, 127);
        for (int t = 0; t < this.descriptorLength - 1; ++t) {
            int cell_id = Utils.getInt(b, offset + 3 + t, 1, 255);
            Cell s = new Cell(cell_id);
            this.cellList.add(s);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("availability_flag", this.availability_flag, this.getAvailabilityString())));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        Utils.addListJTree(t, this.cellList, modus, "cell_ids");
        return t;
    }

    private String getAvailabilityString() {
        return this.availability_flag == 0 ? "service is unavailable on the cells identified by the cell_ids" : "service is available on the cells identified by the cell_ids";
    }

    public List<Cell> getServiceList() {
        return this.cellList;
    }

    public List<Cell> getCellList() {
        return this.cellList;
    }

    public int getAvailability_flag() {
        return this.availability_flag;
    }

    public int getReserved() {
        return this.reserved;
    }

    private static class Cell
    implements TreeNode {
        private int cell_id;

        public Cell(int cell_id) {
            this.cell_id = cell_id;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("cell_id", this.cell_id, null));
            return s;
        }
    }
}

