/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel.AbstractLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.NITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TransportStream;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class ServiceListDescriptor
extends Descriptor
implements TableSource {
    private final List<Service> serviceList = new ArrayList<Service>();
    private DescriptorContext descriptorContext;

    public ServiceListDescriptor(byte[] b, int offset, TableSection parent, DescriptorContext descriptorContext) {
        super(b, offset, parent);
        this.descriptorContext = descriptorContext;
        for (int t = 0; t < this.descriptorLength; t += 3) {
            int serviceId = Utils.getInt(b, offset + 2 + t, 2, 65535);
            int serviceType = Utils.getInt(b, offset + 4 + t, 1, 255);
            Service s = new Service(serviceId, serviceType);
            this.serviceList.add(s);
        }
    }

    public int getNoServices() {
        return this.serviceList.size();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (int i = 0; i < this.getNoServices(); ++i) {
            Service s = this.serviceList.get(i);
            buf.append("(").append(i).append(";").append(s.getServiceID()).append(":").append(s.getServiceTypeString()).append("),");
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Object object = t.getUserObject();
        if (object instanceof KVP) {
            KVP kvp = (KVP)object;
            kvp.addTableSource(this, "service_list");
        }
        Utils.addListJTree(t, this.serviceList, modus, "service_list", this);
        return t;
    }

    public List<Service> getServiceList() {
        return this.serviceList;
    }

    private static TableHeader<Service, Service> buildTableHeader() {
        return new TableHeaderBuilder().addRequiredRowColumn("service_id", Service::getServiceID, Integer.class).addRequiredRowColumn("service_type", Service::getServiceType, Integer.class).addRequiredRowColumn("service type description", Service::getServiceTypeString, String.class).addOptionalRowColumn("service name", Service::getServiceName, String.class).build();
    }

    @Override
    public TableModel getTableModel() {
        FlexTableModel<Service, Service> tableModel = new FlexTableModel<Service, Service>(ServiceListDescriptor.buildTableHeader());
        for (Service service : this.serviceList) {
            tableModel.addData(service, List.of(service));
        }
        tableModel.process();
        return tableModel;
    }

    public class Service
    implements TreeNode {
        private int serviceID;
        private int serviceType;

        public Service(int id, int type) {
            this.serviceID = id;
            this.serviceType = type;
        }

        public int getServiceID() {
            return this.serviceID;
        }

        public void setServiceID(int serviceID) {
            this.serviceID = serviceID;
        }

        public int getServiceType() {
            return this.serviceType;
        }

        public String getServiceTypeString() {
            return Descriptor.getServiceTypeString(this.serviceType);
        }

        public void setServiceType(int serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            String serviceName;
            Object nodeLabel = "service";
            if (ServiceListDescriptor.this.descriptorContext.hasOnidTsid() && (serviceName = this.getServiceName()) != null) {
                nodeLabel = "service (" + serviceName + ")";
            }
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP((String)nodeLabel));
            s.add(new DefaultMutableTreeNode(new KVP("service_id", this.serviceID, null)));
            s.add(new DefaultMutableTreeNode(new KVP("service_type", this.serviceType, Descriptor.getServiceTypeString(this.serviceType))));
            return s;
        }

        public String getServiceName() {
            return ServiceListDescriptor.this.getPSI().getSdt().getServiceName(ServiceListDescriptor.this.descriptorContext.original_network_id, ServiceListDescriptor.this.descriptorContext.transport_stream_id, this.serviceID);
        }

        public Integer getLCN() {
            NITsection[] networkSections;
            for (NITsection section : networkSections = ServiceListDescriptor.this.getPSI().getNit().getNetworks().get(ServiceListDescriptor.this.descriptorContext.getNetwork_id())) {
                TransportStream stream;
                if (section == null || (stream = section.getTransportStream(ServiceListDescriptor.this.descriptorContext.transport_stream_id)) == null) continue;
                for (Descriptor descriptor : stream.descriptorList()) {
                    AbstractLogicalChannelDescriptor abstractLogicalChannelDescriptor;
                    Integer lcn;
                    if (!(descriptor instanceof AbstractLogicalChannelDescriptor) || (lcn = (abstractLogicalChannelDescriptor = (AbstractLogicalChannelDescriptor)descriptor).getLCN(this.serviceID)) == null) continue;
                    return lcn;
                }
                return null;
            }
            return null;
        }
    }
}

