/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LanguageDependentEitDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ShortEventDescriptor
extends LanguageDependentEitDescriptor {
    private String iso639LanguageCode;
    private final DVBString eventName;
    private DVBString text;

    public ShortEventDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.iso639LanguageCode = Utils.getISO8859_1String(b, 2, 3);
        int eventNameLength = Utils.getInt(b, 5, 1, 255);
        this.eventName = new DVBString(b, 5);
        this.text = new DVBString(b, 6 + eventNameLength);
    }

    @Override
    public String getIso639LanguageCode() {
        return this.iso639LanguageCode;
    }

    @Override
    public String toString() {
        return super.toString() + ",eventName=" + this.eventName.toString() + ",ISO_639_language_code=" + this.getIso639LanguageCode();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        if (Utils.simpleModus(modus)) {
            t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            if (this.eventName.getLength() > 0) {
                t.add(new KVP("event_name", this.eventName));
            }
            if (this.text.getLength() > 0) {
                t.add(new KVP("text", this.text));
            }
        } else {
            t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            t.add(new KVP("event_name", this.eventName));
            t.add(new KVP("text", this.text));
        }
        return t;
    }

    public DVBString getEventName() {
        return this.eventName;
    }

    public DVBString getText() {
        return this.text;
    }
}

