/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCStreamEventPayloadBinary;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class StreamEventDescriptor
extends Descriptor {
    private int eventId;
    private int reserved;
    private long eventNPT;
    private final byte[] privateDataByte;
    private DSMCCStreamEventPayloadBinary dsm_cc_stream_event_payload_binary;

    public StreamEventDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.eventId = Utils.getInt(b, offset + 2, 2, 65535);
        this.reserved = Utils.getInt(b, offset + 4, 4, Integer.MAX_VALUE) >> 1;
        this.eventNPT = Utils.getLong(b, offset + 7, 5, 0x1FFFFFFFFL);
        this.privateDataByte = Utils.getBytes(b, offset + 12, this.descriptorLength - 10);
        try {
            this.dsm_cc_stream_event_payload_binary = new DSMCCStreamEventPayloadBinary(this.privateDataByte);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("eventId", this.eventId, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("eventNPT", this.eventNPT, null)));
        t.add(new DefaultMutableTreeNode(new KVP("privateDataByte", this.privateDataByte, null)));
        if (this.dsm_cc_stream_event_payload_binary != null) {
            t.add(this.dsm_cc_stream_event_payload_binary.getJTreeNode(modus));
        }
        return t;
    }
}

