/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TargetBackGroundDescriptor
extends Descriptor {
    private final int horizontalSize;
    private final int verticalSize;
    private final int aspectRatioInformation;

    public TargetBackGroundDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.horizontalSize = Utils.getInt(b, offset + 2, 2, 65532) >> 2;
        this.verticalSize = Utils.getInt(b, offset + 3, 3, 262128) >> 4;
        this.aspectRatioInformation = Utils.getInt(b, offset + 5, 1, 15);
    }

    @Override
    public String toString() {
        return super.toString() + "horizontalSize=" + this.horizontalSize + ",verticalSize=" + this.verticalSize;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("horizontal_size ", this.horizontalSize, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vertical_size", this.verticalSize, null)));
        t.add(new DefaultMutableTreeNode(new KVP("aspect_ratio_information ", this.aspectRatioInformation, Utils.getAspectRatioInformationString(this.aspectRatioInformation))));
        return t;
    }
}

