/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TerrestrialDeliverySystemDescriptor
extends Descriptor {
    private final long frequency;
    private final int bandwidth;
    private final int priority;
    private final int time_Slicing_indicator;
    private final int mpe_FEC_indicator;
    private final int reserved_future_use;
    private final int constellation;
    private final int hierarchy_information;
    private final int code_rate_HP_stream;
    private final int code_rate_LP_stream;
    private final int guard_interval;
    private final int transmission_mode;
    private final int other_frequency_flag;
    private final long reserved_future_use2;

    public TerrestrialDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.frequency = Utils.getLong(b, offset + 2, 4, -1L);
        this.bandwidth = Utils.getInt(b, offset + 6, 1, 224) >>> 5;
        this.priority = Utils.getInt(b, offset + 6, 1, 16) >>> 4;
        this.time_Slicing_indicator = Utils.getInt(b, offset + 6, 1, 8) >>> 3;
        this.mpe_FEC_indicator = Utils.getInt(b, offset + 6, 1, 4) >>> 2;
        this.reserved_future_use = Utils.getInt(b, offset + 6, 1, 3);
        this.constellation = Utils.getInt(b, offset + 7, 1, 192) >>> 6;
        this.hierarchy_information = Utils.getInt(b, offset + 7, 1, 56) >>> 3;
        this.code_rate_HP_stream = Utils.getInt(b, offset + 7, 1, 7);
        this.code_rate_LP_stream = Utils.getInt(b, offset + 8, 1, 224) >>> 5;
        this.guard_interval = Utils.getInt(b, offset + 8, 1, 24) >>> 3;
        this.transmission_mode = Utils.getInt(b, offset + 8, 1, 6) >>> 1;
        this.other_frequency_flag = Utils.getInt(b, offset + 8, 1, 1);
        this.reserved_future_use2 = Utils.getLong(b, offset + 9, 4, -1L);
    }

    public static String getBandwidtString(int b) {
        switch (b) {
            case 0: {
                return "8 MHz";
            }
            case 1: {
                return "7 MHz";
            }
            case 2: {
                return "6 MHz)";
            }
            case 3: {
                return "5 MHz)";
            }
        }
        return "reserved for future use";
    }

    public static String getPriorityString(int p) {
        switch (p) {
            case 0: {
                return "LP (low priority)";
            }
            case 1: {
                return "HP (high priority)";
            }
        }
        return "error";
    }

    public long getFrequency() {
        return this.frequency;
    }

    @Override
    public String toString() {
        return super.toString() + "Frequency=" + this.getFrequency() + ", priority=" + TerrestrialDeliverySystemDescriptor.getPriorityString(this.priority);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, Descriptor.formatTerrestrialFrequency(this.frequency))));
        t.add(new DefaultMutableTreeNode(new KVP("bandwidth", this.bandwidth, TerrestrialDeliverySystemDescriptor.getBandwidtString(this.bandwidth))));
        t.add(new DefaultMutableTreeNode(new KVP("priority", this.priority, TerrestrialDeliverySystemDescriptor.getPriorityString(this.priority))));
        t.add(new DefaultMutableTreeNode(new KVP("Time_Slicing_indicator", this.time_Slicing_indicator, this.getTimeSlicingString())));
        t.add(new DefaultMutableTreeNode(new KVP("MPE-FEC_indicator", this.mpe_FEC_indicator, this.getMpeFecString())));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_future", this.reserved_future_use, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constellation", this.constellation, TerrestrialDeliverySystemDescriptor.getConstellationString(this.constellation))));
        t.add(new DefaultMutableTreeNode(new KVP("hierarchy_information", this.hierarchy_information, TerrestrialDeliverySystemDescriptor.getHierarchyInformationString(this.hierarchy_information))));
        t.add(new DefaultMutableTreeNode(new KVP("code_rate-HP_stream", this.code_rate_HP_stream, TerrestrialDeliverySystemDescriptor.getCodeRateString(this.code_rate_HP_stream))));
        t.add(new DefaultMutableTreeNode(new KVP("code_rate-LP_stream", this.code_rate_LP_stream, TerrestrialDeliverySystemDescriptor.getCodeRateString(this.code_rate_LP_stream))));
        t.add(new DefaultMutableTreeNode(new KVP("guard_interval", this.guard_interval, TerrestrialDeliverySystemDescriptor.getGuardIntervalString(this.guard_interval))));
        t.add(new DefaultMutableTreeNode(new KVP("transmission_mode", this.transmission_mode, TerrestrialDeliverySystemDescriptor.getTransmissionModeString(this.transmission_mode))));
        t.add(new DefaultMutableTreeNode(new KVP("other_frequency_flag", this.other_frequency_flag, this.other_frequency_flag == 1 ? "one or more other frequencies are in use." : "no other frequency is in use")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use2", this.reserved_future_use2, null)));
        return t;
    }

    public String getMpeFecString() {
        return this.mpe_FEC_indicator == 1 ? "MPE-FEC is not used" : "at least one elementary stream uses MPE-FEC.";
    }

    public static String getTransmissionModeString(int transmission_mode) {
        switch (transmission_mode) {
            case 0: {
                return "2k mode";
            }
            case 1: {
                return "8k mode";
            }
            case 2: {
                return "4k mode";
            }
        }
        return "reserved for future use";
    }

    public static String getGuardIntervalString(int guard_interval) {
        switch (guard_interval) {
            case 0: {
                return "1/32";
            }
            case 1: {
                return "1/16";
            }
            case 2: {
                return "1/8";
            }
            case 3: {
                return "1/4";
            }
        }
        return "Illegal value";
    }

    public static String getCodeRateString(int code_rate) {
        switch (code_rate) {
            case 0: {
                return "1/2";
            }
            case 1: {
                return "2/3";
            }
            case 2: {
                return "3/4";
            }
            case 3: {
                return "5/6";
            }
            case 4: {
                return "7/8";
            }
        }
        return "reserved for future use";
    }

    public static String getHierarchyInformationString(int hierarchy_information) {
        switch (hierarchy_information) {
            case 0: {
                return "non-hierarchical, native interleaver";
            }
            case 1: {
                return "\u03b1 = 1, native interleaver";
            }
            case 2: {
                return "\u03b1 = 2, native interleaver";
            }
            case 3: {
                return "\u03b1 = 4, native interleaver";
            }
            case 4: {
                return "non-hierarchical, in-depth interleaver";
            }
            case 5: {
                return "\u03b1 = 1, in-depth interleaver";
            }
            case 6: {
                return "\u03b1 = 2, in-depth interleaver";
            }
            case 7: {
                return "\u03b1 = 4, in-depth interleaver";
            }
        }
        return "Illegal value";
    }

    public static String getConstellationString(int constellation) {
        switch (constellation) {
            case 0: {
                return "QPSK";
            }
            case 1: {
                return "16-QAM";
            }
            case 2: {
                return "64-QAM";
            }
        }
        return "reserved for future use";
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getTime_Slicing_indicator() {
        return this.time_Slicing_indicator;
    }

    public String getTimeSlicingString() {
        return this.time_Slicing_indicator == 1 ? "not used" : "at least one elementary stream uses Time Slicing.";
    }

    public int getMpe_FEC_indicator() {
        return this.mpe_FEC_indicator;
    }

    public int getReserved_future_use() {
        return this.reserved_future_use;
    }

    public int getConstellation() {
        return this.constellation;
    }

    public int getHierarchy_information() {
        return this.hierarchy_information;
    }

    public int getCode_rate_HP_stream() {
        return this.code_rate_HP_stream;
    }

    public int getCode_rate_LP_stream() {
        return this.code_rate_LP_stream;
    }

    public int getGuard_interval() {
        return this.guard_interval;
    }

    public int getTransmission_mode() {
        return this.transmission_mode;
    }

    public int getOther_frequency_flag() {
        return this.other_frequency_flag;
    }

    public long getReserved_future_use2() {
        return this.reserved_future_use2;
    }
}

