/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TimeSliceFecIdentifierDescriptor
extends Descriptor {
    private final int time_slicing;
    private final int mpe_fec;
    private final int frame_size;
    private final int max_burst_duration;
    private final int max_average_rate;
    private final int time_slice_fec_id;
    private final byte[] id_selector_byte;

    public TimeSliceFecIdentifierDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.time_slicing = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.mpe_fec = Utils.getInt(b, offset + 2, 1, 96) >> 5;
        this.frame_size = Utils.getInt(b, offset + 2, 1, 7);
        this.max_burst_duration = Utils.getInt(b, offset + 3, 1, 255);
        this.max_average_rate = Utils.getInt(b, offset + 4, 1, 240) >> 4;
        this.time_slice_fec_id = Utils.getInt(b, offset + 4, 1, 15);
        this.id_selector_byte = Utils.copyOfRange(b, offset + 5, offset + this.descriptorLength + 2);
    }

    @Override
    public String toString() {
        return super.toString() + " time_slicing" + this.time_slicing;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("time_slicing", this.time_slicing, TimeSliceFecIdentifierDescriptor.getTimeSlicingString(this.time_slicing))));
        t.add(new DefaultMutableTreeNode(new KVP("mpe_fec", this.mpe_fec, TimeSliceFecIdentifierDescriptor.getMPE_FECtring(this.mpe_fec))));
        t.add(new DefaultMutableTreeNode(new KVP("frame_size", this.frame_size, TimeSliceFecIdentifierDescriptor.getFrameSizeString(this.frame_size, this.time_slicing, this.mpe_fec, this.time_slice_fec_id))));
        t.add(new DefaultMutableTreeNode(new KVP("max_burst_duration", this.max_burst_duration, TimeSliceFecIdentifierDescriptor.getMaxBurstString(this.max_burst_duration, this.time_slicing, this.time_slice_fec_id))));
        t.add(new DefaultMutableTreeNode(new KVP("max_average_rate", this.max_average_rate, TimeSliceFecIdentifierDescriptor.getMaxAvgRateString(this.max_average_rate, this.time_slice_fec_id))));
        t.add(new DefaultMutableTreeNode(new KVP("time_slice_fec_id", this.time_slice_fec_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("id_selector_byte", this.id_selector_byte, null)));
        return t;
    }

    private static String getMaxBurstString(int max_burst_duration2, int time_slicing2, int time_slice_fec_id2) {
        if (time_slicing2 == 0) {
            return "reserved for future use";
        }
        if (time_slice_fec_id2 == 0) {
            return 20 * (max_burst_duration2 + 1) + " mSecs";
        }
        return "not defined";
    }

    private static String getFrameSizeString(int frame_size2, int time_slicing2, int mpe_fec2, int time_slice_fec_id2) {
        Object r = "";
        if (time_slice_fec_id2 == 0) {
            if (time_slicing2 == 1) {
                r = "Max Burst Size:";
                switch (frame_size2) {
                    case 0: {
                        r = (String)r + "512 kbits ";
                        break;
                    }
                    case 1: {
                        r = (String)r + "1024 kbits ";
                        break;
                    }
                    case 2: {
                        r = (String)r + "1536 kbits ";
                        break;
                    }
                    case 3: {
                        r = (String)r + "2048 kbits ";
                        break;
                    }
                    default: {
                        r = (String)r + "reserved for future use ";
                    }
                }
            }
            if (mpe_fec2 == 1) {
                r = (String)r + "MPE-FEC Frame rows:";
                switch (frame_size2) {
                    case 0: {
                        r = (String)r + "256";
                        break;
                    }
                    case 1: {
                        r = (String)r + "512";
                        break;
                    }
                    case 2: {
                        r = (String)r + "768";
                        break;
                    }
                    case 3: {
                        r = (String)r + "1024";
                        break;
                    }
                    default: {
                        r = (String)r + "reserved for future use";
                        break;
                    }
                }
            }
        } else {
            r = "undefined";
        }
        return r;
    }

    private static String getMaxAvgRateString(int max_avg_r, int time_slice_fec_id2) {
        if (time_slice_fec_id2 == 0) {
            switch (max_avg_r) {
                case 0: {
                    return "16 kbps";
                }
                case 1: {
                    return "32 kbps";
                }
                case 2: {
                    return "64 kbps";
                }
                case 3: {
                    return "128 kbps";
                }
                case 4: {
                    return "256 kbps";
                }
                case 5: {
                    return "512 kbps";
                }
                case 6: {
                    return "1024 kbps";
                }
                case 7: {
                    return "2048 kbps";
                }
            }
            return "reserved for future use ";
        }
        return "undefined";
    }

    public static String getTimeSlicingString(int time_slicing) {
        if (time_slicing == 1) {
            return "Time Slicing being used";
        }
        return "Time Slicing is not used";
    }

    public static String getMPE_FECtring(int m) {
        switch (m) {
            case 0: {
                return "MPE-FEC not used";
            }
            case 1: {
                return "MPE-FEC used";
            }
        }
        return "reserved for future use";
    }
}

