/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class VideoWindowDescriptor
extends Descriptor {
    private final int horizontalOffset;
    private final int verticalOffset;
    private final int windowPriority;

    public VideoWindowDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.horizontalOffset = Utils.getInt(b, offset + 2, 2, 65532) >> 2;
        this.verticalOffset = Utils.getInt(b, offset + 3, 3, 262128) >> 4;
        this.windowPriority = Utils.getInt(b, offset + 5, 1, 15);
    }

    @Override
    public String toString() {
        return super.toString() + "horizontal_offset =" + this.horizontalOffset + ",vertical_offset=" + this.verticalOffset;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("horizontal_offset", this.horizontalOffset, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vertical_offset", this.verticalOffset, null)));
        t.add(new DefaultMutableTreeNode(new KVP("window_priority", this.windowPriority, null)));
        return t;
    }
}

