/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors;

import java.math.BigInteger;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptor;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Utils;

public class TimelineDescriptor
extends AFDescriptor {
    private static final Logger logger = Logger.getLogger(TimelineDescriptor.class.getName());
    private int has_timestamp;
    private int has_ntp;
    private int has_ptp;
    private int has_timecode;
    private int force_reload;
    private int paused;
    private int discontinuity;
    private int reserved;
    private int timeline_id;
    private long timescale;
    private BigInteger media_timestamp;

    public TimelineDescriptor(byte[] b) {
        super(b);
        this.has_timestamp = Utils.getInt(b, 2, 1, 192) >> 6;
        this.has_ntp = Utils.getInt(b, 2, 1, 32) >> 5;
        this.has_ptp = Utils.getInt(b, 2, 1, 16) >> 4;
        this.has_timecode = Utils.getInt(b, 2, 1, 12) >> 2;
        this.force_reload = Utils.getInt(b, 2, 1, 2) >> 1;
        this.paused = Utils.getInt(b, 2, 1, 1);
        this.discontinuity = Utils.getInt(b, 3, 1, 128) >> 7;
        this.reserved = Utils.getInt(b, 3, 1, 127);
        this.timeline_id = Utils.getInt(b, 4, 1, 255);
        int localOffset = 5;
        if (this.has_timestamp != 0) {
            this.timescale = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
            if (this.has_timestamp == 1) {
                this.media_timestamp = Utils.getBigInteger(b, localOffset, 4);
                localOffset += 4;
            } else if (this.has_timestamp == 2) {
                this.media_timestamp = Utils.getBigInteger(b, localOffset, 8);
                localOffset += 8;
            }
        }
        if (this.has_ntp != 0) {
            logger.warning("has_ntp not implemented");
        }
        if (this.has_ptp != 0) {
            logger.warning("has_ptp not implemented");
        }
        if (this.has_timecode != 0) {
            logger.warning("has_timecode not implemented");
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("has_timestamp", this.has_timestamp, null)));
        t.add(new DefaultMutableTreeNode(new KVP("has_ntp", this.has_ntp, null)));
        t.add(new DefaultMutableTreeNode(new KVP("has_ptp", this.has_ptp, null)));
        t.add(new DefaultMutableTreeNode(new KVP("has_timecode", this.has_timecode, null)));
        t.add(new DefaultMutableTreeNode(new KVP("force_reload", this.force_reload, null)));
        t.add(new DefaultMutableTreeNode(new KVP("paused", this.paused, null)));
        t.add(new DefaultMutableTreeNode(new KVP("discontinuity", this.discontinuity, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("timeline_id", this.timeline_id, null)));
        if (this.has_timestamp != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("timescale", this.timescale, null)));
            t.add(new DefaultMutableTreeNode(new KVP("media_timestamp", this.media_timestamp, null)));
        }
        if (this.has_ntp != 0) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("has_ntp")));
        }
        if (this.has_ptp != 0) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("has_ptp")));
        }
        if (this.has_timecode != 0) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("has_timecode")));
        }
        return t;
    }

    public static Logger getLogger() {
        return logger;
    }

    public int getHas_timestamp() {
        return this.has_timestamp;
    }

    public int getHas_ntp() {
        return this.has_ntp;
    }

    public int getHas_ptp() {
        return this.has_ptp;
    }

    public int getHas_timecode() {
        return this.has_timecode;
    }

    public int getForce_reload() {
        return this.force_reload;
    }

    public int getPaused() {
        return this.paused;
    }

    public int getDiscontinuity() {
        return this.discontinuity;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getTimeline_id() {
        return this.timeline_id;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public BigInteger getMedia_timestamp() {
        return this.media_timestamp;
    }
}

