/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ApplicationNameDescriptor
extends AITDescriptor {
    private List<ApplicationName> applicationNames = new ArrayList<ApplicationName>();

    public List<ApplicationName> getApplicationNames() {
        return this.applicationNames;
    }

    public ApplicationNameDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        DVBString application_name;
        for (int t = 0; t < this.descriptorLength; t += 4 + application_name.getLength()) {
            String languageCode = Utils.getISO8859_1String(b, t + 2, 3);
            application_name = new DVBString(b, t + 5);
            ApplicationName applicationName = new ApplicationName(languageCode, application_name);
            this.applicationNames.add(applicationName);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.applicationNames, modus, "application_names");
        return t;
    }

    public record ApplicationName(String iso639LanguageCode, DVBString application_name) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("application_name: " + String.valueOf(this.application_name));
            s.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            s.add(new KVP("application_name", this.application_name));
            return s;
        }
    }
}

