/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBJApplicationDescriptor
extends AITDescriptor {
    private List<Parameter> parameterList = new ArrayList<Parameter>();

    public DVBJApplicationDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int parameter_length;
        for (int t = 0; t < this.descriptorLength; t += parameter_length + 1) {
            parameter_length = Utils.getInt(b, t + 2, 1, 255);
            byte[] parameter_bytes = Arrays.copyOfRange(b, t + 3, t + 3 + parameter_length);
            this.parameterList.add(new Parameter(parameter_length, parameter_bytes));
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.parameterList, modus, "parameters");
        return t;
    }

    record Parameter(int parameter_length, byte[] parameter_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Parameter");
            s.add(new KVP("parameter_length", this.parameter_length));
            s.add(new KVP("parameter_byte", this.parameter_byte));
            return s;
        }
    }
}

