/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SimpleApplicationBoundaryDescriptor
extends AITDescriptor {
    private final int boundary_extension_count;
    private final List<BoundaryExtension> boundaryExtensions = new ArrayList<BoundaryExtension>();

    public SimpleApplicationBoundaryDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.boundary_extension_count = Utils.getInt(b, 2, 1, 255);
        int t = 0;
        for (int extension = 0; extension < this.boundary_extension_count; ++extension) {
            int boundary_extension_length = Utils.getInt(b, t + 3, 1, 255);
            byte[] boundary_extension_bytes = Arrays.copyOfRange(b, t + 4, t + 4 + boundary_extension_length);
            this.boundaryExtensions.add(new BoundaryExtension(boundary_extension_length, boundary_extension_bytes));
            t += boundary_extension_length + 1;
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("boundary_extension_count", this.boundary_extension_count));
        Utils.addListJTree(t, this.boundaryExtensions, modus, "boundary_extensions");
        return t;
    }

    public record BoundaryExtension(int boundary_extension_length, byte[] boundary_extension_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("boundary extension");
            s.add(new KVP("boundary_extension_length", this.boundary_extension_length));
            s.add(new KVP("boundary_extension_byte", this.boundary_extension_byte));
            return s;
        }
    }
}

