/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCDescriptor;
import nl.digitalekabeltelevisie.util.Utils;

public class CachingPriorityDescriptor
extends DSMCCDescriptor {
    private final int priority_value;
    private final int transparency_level;

    public CachingPriorityDescriptor(byte[] b, int offset) {
        super(b, offset);
        this.priority_value = Utils.getInt(b, offset + 2, 1, 255);
        this.transparency_level = Utils.getInt(b, offset + 3, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("priority_value", this.priority_value, null)));
        t.add(new DefaultMutableTreeNode(new KVP("transparency_level", this.transparency_level, CachingPriorityDescriptor.getTransParencyLevelString(this.transparency_level))));
        return t;
    }

    public static String getTransParencyLevelString(int trans) {
        switch (trans) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "Transparent caching";
            }
            case 2: {
                return "Semi-transparent caching";
            }
            case 3: {
                return "Static caching";
            }
        }
        return "reserved for future use";
    }
}

