/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.CRC32Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.CachingPriorityDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.CompressedModuleDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.LabelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.ModuleLinkDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.NameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.SSUModuleTypeDescriptor;

public final class DSMCCDescriptorFactory {
    private static final Logger logger = Logger.getLogger(DSMCCDescriptorFactory.class.getName());

    private DSMCCDescriptorFactory() {
    }

    public static List<Descriptor> buildDescriptorList(byte[] data, int offset, int len) {
        Descriptor d;
        ArrayList<Descriptor> r = new ArrayList<Descriptor>();
        for (int t = 0; t < len; t += d.getDescriptorLength() + 2) {
            int descriptorLen = Byte.toUnsignedInt(data[offset + t + 1]);
            byte[] descriptorData = Arrays.copyOfRange(data, offset + t, offset + t + descriptorLen + 2);
            try {
                d = DSMCCDescriptorFactory.getDSMCCDescriptor(descriptorData);
            }
            catch (RuntimeException iae) {
                d = new DSMCCDescriptor(data, t + offset);
                logger.info("Fall back for descriptor:" + Byte.toUnsignedInt(data[t + offset]) + " (" + DSMCCDescriptor.getDescriptorname(Byte.toUnsignedInt(data[t + offset])) + ")in section DSMCC data=" + d.getRawDataString() + ", RuntimeException:" + String.valueOf(iae));
            }
            r.add(d);
        }
        return r;
    }

    private static Descriptor getDSMCCDescriptor(byte[] data) {
        DSMCCDescriptor d;
        switch (Byte.toUnsignedInt(data[0])) {
            case 2: {
                d = new NameDescriptor(data);
                break;
            }
            case 4: {
                d = new ModuleLinkDescriptor(data, 0);
                break;
            }
            case 5: {
                d = new CRC32Descriptor(data, 0);
                break;
            }
            case 9: {
                d = new CompressedModuleDescriptor(data, 0);
                break;
            }
            case 10: {
                d = new SSUModuleTypeDescriptor(data, 0);
                break;
            }
            case 112: {
                d = new LabelDescriptor(data, 0);
                break;
            }
            case 113: {
                d = new CachingPriorityDescriptor(data, 0);
                break;
            }
            default: {
                d = new DSMCCDescriptor(data, 0);
                logger.info("Not implemented DSMCCDescriptor:" + Byte.toUnsignedInt(data[0]) + " (" + DSMCCDescriptor.getDescriptorname(Byte.toUnsignedInt(data[0])) + ",) data=" + d.getRawDataString());
            }
        }
        return d;
    }
}

