/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc;

import java.util.Arrays;
import java.util.Base64;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DSMCCStreamEventPayloadBinary
implements TreeNode {
    private byte[] binary;
    private int dvb_data_length;
    private int reserved_zero_future_use;
    private int event_type;
    private int timeline_type;
    private int temi_component_tag;
    private int temi_timeline_id;
    private byte[] reserved_zero_future_use2;
    private int private_data_length;
    private long private_data_specifier;
    private byte[] private_data_byte;
    private DVBString carousel_object_name;
    SpliceInfoSection scte35_section;

    public DSMCCStreamEventPayloadBinary(byte[] privateDataByte) {
        Base64.Decoder base64Decoder = Base64.getDecoder();
        this.binary = base64Decoder.decode(privateDataByte);
        if (this.binary.length > 0) {
            this.dvb_data_length = Utils.getInt(this.binary, 0, 1, 255);
            int byte1 = Utils.getInt(this.binary, 1, 1, 255);
            this.reserved_zero_future_use = (byte1 & 0xE0) >> 5;
            this.event_type = (byte1 & 0x10) >> 4;
            this.timeline_type = byte1 & 0xF;
            int offset = 2;
            if (this.timeline_type == 2) {
                this.temi_component_tag = Utils.getInt(this.binary, offset++, 1, 255);
                this.temi_timeline_id = Utils.getInt(this.binary, offset++, 1, 255);
            }
            if (this.dvb_data_length + 1 > offset) {
                this.reserved_zero_future_use2 = Arrays.copyOfRange(this.binary, offset, offset - 1 - this.dvb_data_length);
                offset = this.dvb_data_length + 1;
            }
            this.private_data_length = Utils.getInt(this.binary, offset++, 1, 255);
            if (this.private_data_length > 0) {
                this.private_data_specifier = Utils.getLong(this.binary, offset, 4, -1L);
                this.private_data_byte = Utils.getBytes(this.binary, offset += 4, this.private_data_length - 4);
            }
            if (this.event_type == 1) {
                this.carousel_object_name = new DVBString(this.binary, offset);
                offset += 1 + this.carousel_object_name.getLength();
            }
            if (this.event_type == 0) {
                PsiSectionData psiSectionData = new PsiSectionData(Arrays.copyOfRange(this.binary, offset, this.binary.length));
                this.scte35_section = new SpliceInfoSection(psiSectionData, null);
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("DSM-CC_stream_event_payload_binary");
        t.add(new KVP("binary", this.binary));
        if (this.binary.length > 0) {
            t.add(new KVP("DVB_data_length", this.dvb_data_length));
            t.add(new KVP("reserved_zero_future_use", this.reserved_zero_future_use));
            t.add(new KVP("event_type", this.event_type));
            t.add(new KVP("timeline_type", this.timeline_type));
            if (this.timeline_type == 2) {
                t.add(new KVP("temi_component_tag", this.temi_component_tag));
                t.add(new KVP("temi_timeline_id", this.temi_timeline_id));
            }
            if (this.reserved_zero_future_use2 != null) {
                t.add(new KVP("reserved_zero_future_use", this.reserved_zero_future_use2));
            }
            t.add(new KVP("private_data_length", this.private_data_length));
            if (this.private_data_length > 0) {
                t.add(new KVP("private_data_specifier", this.private_data_specifier).setDescription(Utils.getPrivateDataSpecString(this.private_data_specifier)));
                t.add(new KVP("private_data_byte", this.private_data_byte));
            }
            if (this.event_type == 1) {
                t.add(new KVP("carousel_object_name", this.carousel_object_name));
            }
            if (this.event_type == 0) {
                t.add(this.scte35_section.getJTreeNode(2));
            }
        }
        return t;
    }
}

