/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCDescriptor;
import nl.digitalekabeltelevisie.util.Utils;

public class SSUModuleTypeDescriptor
extends DSMCCDescriptor {
    private final int ssu_module_type;

    public SSUModuleTypeDescriptor(byte[] b, int offset) {
        super(b, offset);
        this.ssu_module_type = Utils.getInt(b, offset + 2, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("SSU_module_type", this.ssu_module_type, SSUModuleTypeDescriptor.getSSUModuleTypeString(this.ssu_module_type))));
        return t;
    }

    public static String getSSUModuleTypeString(int trans) {
        switch (trans) {
            case 0: {
                return "executable module type";
            }
            case 1: {
                return "memory mapped code module type";
            }
            case 2: {
                return "data module type";
            }
        }
        return "reserved for future use";
    }
}

