/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Utils;

public class S2XSatelliteDeliverySystemDescriptor
extends DVBExtensionDescriptor {
    private final int receiver_profiles;
    private final int reserved_zero_future_use1;
    private final int S2X_mode;
    private final int scrambling_sequence_selector;
    private final int reserved_zero_future_use2;
    private final int TS_GS_S2X_mode;
    private int reserved_zero_future_use3;
    private int scrambling_sequence_index;
    private String frequency;
    private final String orbitalPosition;
    private final int westEastFlag;
    private final int polarization;
    private final int multiple_input_stream_flag;
    private final int reserved_zero_future_use4;
    private final int rollOff;
    private final int reserved_zero_future_use5;
    private String symbol_rate;
    private int input_stream_identifier;
    private int timeslice_number;

    public S2XSatelliteDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.receiver_profiles = Utils.getInt(b, offset + 3, 1, 248) >> 3;
        this.reserved_zero_future_use1 = Utils.getInt(b, offset + 3, 1, 7);
        this.S2X_mode = Utils.getInt(b, offset + 4, 1, 192) >> 6;
        this.scrambling_sequence_selector = Utils.getInt(b, offset + 4, 1, 32) >> 5;
        this.reserved_zero_future_use2 = Utils.getInt(b, offset + 4, 1, 28) >> 2;
        this.TS_GS_S2X_mode = Utils.getInt(b, offset + 4, 1, 3);
        int localOffset = offset + 5;
        if (this.scrambling_sequence_selector == 1) {
            this.reserved_zero_future_use3 = Utils.getInt(b, localOffset, 1, 252) >> 2;
            this.scrambling_sequence_index = Utils.getInt(b, localOffset, 3, 262143);
            localOffset += 3;
        }
        this.frequency = Utils.getBCD(b, localOffset * 2, 8);
        this.orbitalPosition = Utils.getBCD(b, (localOffset += 4) * 2, 4);
        this.westEastFlag = Utils.getInt(b, localOffset += 2, 1, 128) >> 7;
        this.polarization = Utils.getInt(b, localOffset, 1, 96) >> 5;
        this.multiple_input_stream_flag = Utils.getInt(b, localOffset, 1, 16) >> 4;
        this.reserved_zero_future_use4 = Utils.getInt(b, localOffset, 1, 8) >> 3;
        this.rollOff = Utils.getInt(b, localOffset, 1, 7);
        this.reserved_zero_future_use5 = Utils.getInt(b, ++localOffset, 1, 240) >> 4;
        this.symbol_rate = Utils.getBCD(b, localOffset * 2 + 1, 7);
        localOffset += 4;
        if (this.multiple_input_stream_flag == 1) {
            this.input_stream_identifier = Utils.getInt(b, localOffset, 1, 255);
            ++localOffset;
        }
        if (this.S2X_mode == 2) {
            this.timeslice_number = Utils.getInt(b, localOffset, 1, 255);
            ++localOffset;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("receiver_profiles", this.receiver_profiles, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("S2X_mode", this.S2X_mode, null)));
        t.add(new DefaultMutableTreeNode(new KVP("scrambling_sequence_selector", this.scrambling_sequence_selector, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use2, null)));
        t.add(new DefaultMutableTreeNode(new KVP("TS_GS_S2X_mode", this.TS_GS_S2X_mode, S2XSatelliteDeliverySystemDescriptor.getTS_GS_S2X_modeString(this.TS_GS_S2X_mode))));
        if (this.scrambling_sequence_selector == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use3, null)));
            t.add(new DefaultMutableTreeNode(new KVP("scrambling_sequence_index", this.scrambling_sequence_index, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, Descriptor.formatSatelliteFrequency(this.frequency))));
        t.add(new DefaultMutableTreeNode(new KVP("orbital_position", this.orbitalPosition, Descriptor.formatOrbitualPosition(this.orbitalPosition))));
        t.add(new DefaultMutableTreeNode(new KVP("west_east_flag", this.westEastFlag, this.westEastFlag == 1 ? "east" : "west")));
        t.add(new DefaultMutableTreeNode(new KVP("polarization", this.polarization, SatelliteDeliverySystemDescriptor.getPolarizationString(this.polarization))));
        t.add(new DefaultMutableTreeNode(new KVP("multiple_input_stream_flag", this.multiple_input_stream_flag, this.multiple_input_stream_flag == 1 ? "multiple transport streams are conveyed" : "single transport stream is carried")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use4, null)));
        t.add(new DefaultMutableTreeNode(new KVP("roll_off", this.rollOff, S2XSatelliteDeliverySystemDescriptor.getS2XRollOffString(this.rollOff))));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use5, null)));
        t.add(new DefaultMutableTreeNode(new KVP("symbol_rate", this.symbol_rate, Descriptor.formatSymbolRate(this.symbol_rate))));
        if (this.multiple_input_stream_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("input_stream_identifier", this.input_stream_identifier, null)));
        }
        if (this.S2X_mode == 2) {
            t.add(new DefaultMutableTreeNode(new KVP("timeslice_number", this.timeslice_number, null)));
        }
        if (this.S2X_mode == 3) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("S2X_mode==3")));
        }
        return t;
    }

    private static String getTS_GS_S2X_modeString(int tS_GS_S2X_mode2) {
        switch (tS_GS_S2X_mode2) {
            case 0: {
                return "generic packetized";
            }
            case 1: {
                return "GSE";
            }
            case 2: {
                return "GSE high efficiency mode";
            }
            case 3: {
                return "Transport Stream";
            }
        }
        return "illegal value";
    }

    public static String getS2XRollOffString(int pol) {
        switch (pol) {
            case 0: {
                return "\u03b1 = 0,35";
            }
            case 1: {
                return "\u03b1 = 0,25";
            }
            case 2: {
                return "\u03b1 = 0,20";
            }
            case 3: {
                return "reserved";
            }
            case 4: {
                return "\u03b1 = 0,15";
            }
            case 5: {
                return "\u03b1 = 0,10";
            }
            case 6: {
                return "\u03b1 = 0,05";
            }
            case 7: {
                return "reserved";
            }
        }
        return "illegal value";
    }
}

