/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class ServiceProminenceDescriptor
extends DVBExtensionDescriptor {
    private final int sogi_list_length;
    private final List<ServiceOfGeneralInterest> sogiList = new ArrayList<ServiceOfGeneralInterest>();
    private byte[] private_data_byte;

    public ServiceProminenceDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.sogi_list_length = Utils.getInt(b, offset + 3, 1, 255);
        BitSource bitSourceWholeDescriptor = new BitSource(this.selector_byte, 1);
        BitSource bitSourceOsgiList = new BitSource(bitSourceWholeDescriptor, this.sogi_list_length);
        while (bitSourceOsgiList.available() >= 2) {
            ServiceOfGeneralInterest serviceOfGeneralInterest = new ServiceOfGeneralInterest(this, bitSourceOsgiList);
            this.sogiList.add(serviceOfGeneralInterest);
        }
        bitSourceWholeDescriptor.advanceBytes(this.sogi_list_length);
        this.private_data_byte = bitSourceWholeDescriptor.readBytes(bitSourceWholeDescriptor.available() / 8);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("SOGI_list_length", this.sogi_list_length, null)));
        Utils.addToList(t, this.sogiList, modus);
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
        return t;
    }

    private class ServiceOfGeneralInterest
    implements TreeNode {
        private int SOGI_flag;
        private int target_region_flag;
        private int service_flag;
        private int reserved_future_use;
        private int SOGI_priority;
        private int service_id;
        private int target_region_loop_length;
        private List<TargetRegion> targetRegionList = new ArrayList<TargetRegion>();

        public ServiceOfGeneralInterest(ServiceProminenceDescriptor serviceProminenceDescriptor, BitSource bs) {
            this.SOGI_flag = bs.readBits(1);
            this.target_region_flag = bs.readBits(1);
            this.service_flag = bs.readBits(1);
            this.reserved_future_use = bs.readBits(1);
            this.SOGI_priority = bs.readBits(12);
            if (this.service_flag == 1) {
                this.service_id = bs.readBits(16);
            }
            if (this.target_region_flag == 1) {
                this.target_region_loop_length = bs.readBits(8);
                BitSource targetRegionBitSource = new BitSource(bs, this.target_region_loop_length);
                while (targetRegionBitSource.available() > 0) {
                    TargetRegion targetRegion = new TargetRegion(this, targetRegionBitSource);
                    this.targetRegionList.add(targetRegion);
                }
                bs.advanceBytes(this.target_region_loop_length);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Service Of General Interest"));
            t.add(new DefaultMutableTreeNode(new KVP("SOGI_flag", this.SOGI_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("target_region_flag", this.target_region_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("service_flag", this.service_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved_future_use, null)));
            t.add(new DefaultMutableTreeNode(new KVP("SOGI_priority", this.SOGI_priority, null)));
            if (this.service_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("service_id", this.service_id, null)));
            }
            if (this.target_region_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("target_region_loop_length", this.target_region_loop_length, null)));
                Utils.addToList(t, this.targetRegionList, modus);
            }
            return t;
        }

        private class TargetRegion
        implements TreeNode {
            private int reserved_future_use;
            private int country_code_flag;
            private int region_depth;
            private byte[] country_code;
            private int primary_region_code;
            private int secondary_region_code;
            private int tertiary_region_code;

            public TargetRegion(ServiceOfGeneralInterest serviceOfGeneralInterest, BitSource bs) {
                this.reserved_future_use = bs.readBits(5);
                this.country_code_flag = bs.readBits(1);
                this.region_depth = bs.readBits(2);
                if (this.country_code_flag == 1) {
                    this.country_code = bs.readBytes(3);
                }
                if (this.region_depth >= 1) {
                    this.primary_region_code = bs.readBits(8);
                    if (this.region_depth >= 2) {
                        this.secondary_region_code = bs.readBits(8);
                        if (this.region_depth == 3) {
                            this.tertiary_region_code = bs.readBits(16);
                        }
                    }
                }
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Target Region"));
                t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved_future_use, null)));
                t.add(new DefaultMutableTreeNode(new KVP("country_code_flag", this.country_code_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("region_depth", this.region_depth, null)));
                if (this.country_code_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("country_code", this.country_code, Utils.getISO8859_1String(this.country_code, 0, 3))));
                }
                if (this.region_depth >= 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("primary_region_code", this.primary_region_code, null)));
                    if (this.region_depth >= 2) {
                        t.add(new DefaultMutableTreeNode(new KVP("secondary_region_code", this.secondary_region_code, null)));
                        if (this.region_depth == 3) {
                            t.add(new DefaultMutableTreeNode(new KVP("tertiary_region_code", this.tertiary_region_code, null)));
                        }
                    }
                }
                return t;
            }
        }
    }
}

