/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SupplementaryAudioDescriptor
extends DVBExtensionDescriptor {
    private final int mix_type;
    private final int editorial_classification;
    private final int language_code_present;
    private String iso639LanguageCode;
    private final byte[] private_data_byte;

    public SupplementaryAudioDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.mix_type = Utils.getInt(b, offset + 3, 1, 128) >> 7;
        this.editorial_classification = Utils.getInt(b, offset + 3, 1, 124) >> 2;
        this.language_code_present = Utils.getInt(b, offset + 3, 1, 1);
        int t = 4;
        if (this.language_code_present == 1) {
            this.iso639LanguageCode = Utils.getISO8859_1String(b, offset + 4, 3);
            t = 7;
        }
        this.private_data_byte = Arrays.copyOfRange(b, offset + t, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("mix_type", this.mix_type, this.mix_type == 0 ? "Audio stream is a supplementary stream" : "Audio stream is a complete and independent stream")));
        t.add(new DefaultMutableTreeNode(new KVP("editorial_classification", this.editorial_classification, SupplementaryAudioDescriptor.getEditorialClassificationString(this.editorial_classification))));
        t.add(new DefaultMutableTreeNode(new KVP("language_code_present", this.language_code_present, null)));
        if (this.language_code_present == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
        return t;
    }

    public static String getEditorialClassificationString(int editorial_classification) {
        switch (editorial_classification) {
            case 0: {
                return "Main audio";
            }
            case 1: {
                return "Audio description for the visually impaired";
            }
            case 2: {
                return "Clean audio for the hearing impaired";
            }
            case 3: {
                return "Spoken subtitles for the visually impaired";
            }
            case 4: {
                return "Dependent parametric data stream";
            }
            case 23: {
                return "Unspecific supplementary audio for the general audience";
            }
        }
        return "reserved for future use";
    }
}

