/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class T2DeliverySystemDescriptor
extends DVBExtensionDescriptor {
    private static final LookUpList siso_miso_mode_list = new LookUpList.Builder().add(0, "SISO").add(1, "MISO").add(2, "reserved for future use").add(3, "reserved for future use").build();
    private static final LookUpList bandwidth_list = new LookUpList.Builder().add(0, "8 MHz").add(1, "7 MHz").add(2, "6 MHz").add(3, "5 MHz").add(4, "10 MHz").add(5, "1,712 MHz").add(7, 15, "reserved for future use").build();
    private static final LookUpList guard_interval_list = new LookUpList.Builder().add(0, "1/32").add(1, "1/16").add(2, "1/8").add(3, "1/4").add(4, "1/128").add(5, "19/128").add(6, "19/256").add(7, "reserved for future use").build();
    private static final LookUpList transmission_mode_list = new LookUpList.Builder().add(0, "2k mode").add(1, "8k mode").add(2, "4k mode").add(3, "1k mode").add(4, "16k mode").add(5, "32k mode").add(6, 7, "reserved for future use").build();
    private final int plp_id;
    private final int t2_system_id;
    private int siso_miso;
    private int bandwidth;
    private int reserved_future_use;
    private int guard_interval;
    private int transmission_mode;
    private int other_frequency_flag;
    private int tfs_flag;
    private List<CellInfo> cellInfoList = new ArrayList<CellInfo>();

    public T2DeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.plp_id = Utils.getInt(b, offset + 3, 1, 255);
        this.t2_system_id = Utils.getInt(b, offset + 4, 2, 65535);
        if (this.descriptorLength > 4) {
            this.siso_miso = Utils.getInt(b, offset + 6, 1, 192) >> 6;
            this.bandwidth = Utils.getInt(b, offset + 6, 1, 60) >> 2;
            this.reserved_future_use = Utils.getInt(b, offset + 6, 1, 3);
            this.guard_interval = Utils.getInt(b, offset + 7, 1, 224) >> 5;
            this.transmission_mode = Utils.getInt(b, offset + 7, 1, 28) >> 2;
            this.other_frequency_flag = Utils.getInt(b, offset + 7, 1, 2) >> 1;
            this.tfs_flag = Utils.getInt(b, offset + 7, 1, 1);
            BitSource bs = new BitSource(b, offset + 8, offset + this.descriptorLength + 2);
            while (bs.available() > 0) {
                CellInfo ci = new CellInfo(bs);
                this.cellInfoList.add(ci);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("plp_id", this.plp_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("T2_system_id", this.t2_system_id, null)));
        if (this.descriptorLength > 4) {
            t.add(new DefaultMutableTreeNode(new KVP("siso_miso", this.siso_miso, siso_miso_mode_list.get(this.siso_miso))));
            t.add(new DefaultMutableTreeNode(new KVP("bandwidth", this.bandwidth, bandwidth_list.get(this.bandwidth))));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved_future_use, null)));
            t.add(new DefaultMutableTreeNode(new KVP("guard_interval", this.guard_interval, guard_interval_list.get(this.guard_interval))));
            t.add(new DefaultMutableTreeNode(new KVP("transmission_mode", this.transmission_mode, transmission_mode_list.get(this.transmission_mode))));
            t.add(new DefaultMutableTreeNode(new KVP("other_frequency_flag", this.other_frequency_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("tfs_flag", this.tfs_flag, this.tfs_flag == 0 ? "No TFS arrangement in place" : "TFS arrangement in place ")));
            Utils.addListJTree(t, this.cellInfoList, modus, "cell_info_loop");
        }
        return t;
    }

    public static LookUpList getSisoMisoModeList() {
        return siso_miso_mode_list;
    }

    public static LookUpList getBandwidthList() {
        return bandwidth_list;
    }

    public static LookUpList getGuardIntervalList() {
        return guard_interval_list;
    }

    public static LookUpList getTransmissionModeList() {
        return transmission_mode_list;
    }

    public int getPlp_id() {
        return this.plp_id;
    }

    public int getT2_system_id() {
        return this.t2_system_id;
    }

    public int getSiso_miso() {
        return this.siso_miso;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getReserved_future_use() {
        return this.reserved_future_use;
    }

    public int getGuard_interval() {
        return this.guard_interval;
    }

    public int getTransmission_mode() {
        return this.transmission_mode;
    }

    public int getOther_frequency_flag() {
        return this.other_frequency_flag;
    }

    public int getTfs_flag() {
        return this.tfs_flag;
    }

    public List<CellInfo> getCellInfoList() {
        return this.cellInfoList;
    }

    private class CellInfo
    implements TreeNode {
        private int cell_id;
        private int frequency_loop_length;
        private List<CentreFrequency> centreFrequencyList = new ArrayList<CentreFrequency>();
        private int centre_frequency;
        private int subcell_info_loop_length;
        private List<SubCellInfo> subCellInfoList = new ArrayList<SubCellInfo>();

        public CellInfo(BitSource bs) {
            this.cell_id = bs.readBits(16);
            if (T2DeliverySystemDescriptor.this.tfs_flag == 1) {
                this.frequency_loop_length = bs.readBits(8);
                for (int j = 0; j < this.frequency_loop_length / 4; ++j) {
                    int centre_frequency = bs.readBits(32);
                    this.centreFrequencyList.add(new CentreFrequency(this, centre_frequency));
                }
            } else {
                this.centre_frequency = bs.readBits(32);
            }
            this.subcell_info_loop_length = bs.readBits(8);
            for (int k = 0; k < this.subcell_info_loop_length / 5; ++k) {
                int cell_id_extension = bs.readBits(8);
                int transposer_frequency = bs.readBits(32);
                this.subCellInfoList.add(new SubCellInfo(this, cell_id_extension, transposer_frequency));
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("CellInfo"));
            s.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cell_id, null)));
            if (T2DeliverySystemDescriptor.this.tfs_flag == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("frequency_loop_length", this.frequency_loop_length, null)));
                Utils.addListJTree(s, this.centreFrequencyList, modus, "centre frequencies");
            } else {
                s.add(new DefaultMutableTreeNode(new KVP("centre_frequency", this.centre_frequency, Descriptor.formatTerrestrialFrequency(this.centre_frequency))));
            }
            s.add(new DefaultMutableTreeNode(new KVP("subcell_info_loop_length", this.subcell_info_loop_length, null)));
            Utils.addListJTree(s, this.subCellInfoList, modus, "subcell_info_loop");
            return s;
        }

        public class CentreFrequency
        implements TreeNode {
            private final int centre_frequency;

            public CentreFrequency(CellInfo this$1, int centre_frequency) {
                this.centre_frequency = centre_frequency;
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                return new DefaultMutableTreeNode(new KVP("centre_frequency", this.centre_frequency, Descriptor.formatTerrestrialFrequency(this.centre_frequency)));
            }
        }

        public class SubCellInfo
        implements TreeNode {
            int cell_id_extension;
            int transposer_frequency;

            public SubCellInfo(CellInfo this$1, int cell_id_extension, int transposer_frequency) {
                this.cell_id_extension = cell_id_extension;
                this.transposer_frequency = transposer_frequency;
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("SubCellInfo"));
                s.add(new DefaultMutableTreeNode(new KVP("cell_id_extension", this.cell_id_extension, null)));
                s.add(new DefaultMutableTreeNode(new KVP("transposer_frequency", this.transposer_frequency, Descriptor.formatTerrestrialFrequency(this.transposer_frequency))));
                return s;
            }
        }
    }
}

