/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class TargetRegionDescriptor
extends DVBExtensionDescriptor {
    private final String country_code;
    private final List<TargetRegion> targetRegions = new ArrayList<TargetRegion>();

    public TargetRegionDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.country_code = Utils.getISO8859_1String(this.selector_byte, 0, 3);
        BitSource bs = new BitSource(this.selector_byte, 3);
        while (bs.available() > 0) {
            int reserved = bs.readBits(5);
            int country_code_flag = bs.readBits(1);
            int region_depth = bs.readBits(2);
            int primary_region_code = 0;
            int secondary_region_code = 0;
            int tertiary_region_code = 0;
            byte[] countryCodeBytes = null;
            if (country_code_flag == 1) {
                countryCodeBytes = bs.readBytes(3);
            }
            if (region_depth >= 1) {
                primary_region_code = bs.readBits(8);
                if (region_depth >= 2) {
                    secondary_region_code = bs.readBits(8);
                    if (region_depth == 3) {
                        tertiary_region_code = bs.readBits(16);
                    }
                }
            }
            this.targetRegions.add(new TargetRegion(reserved, country_code_flag, region_depth, countryCodeBytes, primary_region_code, secondary_region_code, tertiary_region_code));
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("country_code", this.country_code, null)));
        Utils.addToList(t, this.targetRegions, modus);
        return t;
    }

    private static class TargetRegion
    implements TreeNode {
        private final int reserved;
        private final int country_code_flag;
        private final int region_dept;
        private String country_code;
        private final int primary_region_code;
        private final int secondary_region_code;
        private final int tertiary_region_code;

        private TargetRegion(int reserved, int country_code_flag, int region_dept, byte[] country_codeBytes, int primary_region_code, int secondary_region_code, int tertiary_region_code) {
            this.reserved = reserved;
            this.country_code_flag = country_code_flag;
            this.region_dept = region_dept;
            if (country_code_flag == 1 && country_codeBytes.length > 0) {
                this.country_code = Utils.getISO8859_1String(country_codeBytes, 0, 3);
            }
            this.primary_region_code = primary_region_code;
            this.secondary_region_code = secondary_region_code;
            this.tertiary_region_code = tertiary_region_code;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("TargetRegion"));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            t.add(new DefaultMutableTreeNode(new KVP("country_code_flag", this.country_code_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("region_dept", this.region_dept, null)));
            if (this.country_code_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("country_code", this.country_code, null)));
            }
            if (this.region_dept >= 1) {
                t.add(new DefaultMutableTreeNode(new KVP("primary_region_code", this.primary_region_code, null)));
                if (this.region_dept >= 2) {
                    t.add(new DefaultMutableTreeNode(new KVP("secondary_region_code", this.secondary_region_code, null)));
                    if (this.region_dept == 3) {
                        t.add(new DefaultMutableTreeNode(new KVP("tertiary_region_code", this.tertiary_region_code, null)));
                    }
                }
            }
            return t;
        }
    }
}

