/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class TargetRegionNameDescriptor
extends DVBExtensionDescriptor {
    private final String country_code;
    private final String iso_639_language_code;
    private final List<TargetRegionName> targetRegions = new ArrayList<TargetRegionName>();

    public TargetRegionNameDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.country_code = Utils.getISO8859_1String(this.selector_byte, 0, 3);
        this.iso_639_language_code = Utils.getISO8859_1String(this.selector_byte, 3, 3);
        BitSource bs = new BitSource(this.selector_byte, 6);
        while (bs.available() > 0) {
            int region_depth = bs.readBits(2);
            int region_name_length = bs.readBits(6);
            byte[] region_name = bs.readBytes(region_name_length);
            int primary_region_code = bs.readBits(8);
            int secondary_region_code = 0;
            int tertiary_region_code = 0;
            if (region_depth >= 2) {
                secondary_region_code = bs.readBits(8);
                if (region_depth == 3) {
                    tertiary_region_code = bs.readBits(16);
                }
            }
            this.targetRegions.add(new TargetRegionName(this, region_depth, region_name_length, region_name, primary_region_code, secondary_region_code, tertiary_region_code));
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("country_code", this.country_code, null)));
        t.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso_639_language_code, null)));
        Utils.addToList(t, this.targetRegions, modus);
        return t;
    }

    private class TargetRegionName
    implements TreeNode {
        private final int region_dept;
        private final int region_name_length;
        private final String region_name;
        private final int primary_region_code;
        private final int secondary_region_code;
        private final int tertiary_region_code;

        private TargetRegionName(TargetRegionNameDescriptor targetRegionNameDescriptor, int region_dept, int region_name_length, byte[] region_name, int primary_region_code, int secondary_region_code, int tertiary_region_code) {
            this.region_dept = region_dept;
            this.region_name_length = region_name_length;
            this.region_name = Utils.getString(region_name, 0, region_name_length);
            this.primary_region_code = primary_region_code;
            this.secondary_region_code = secondary_region_code;
            this.tertiary_region_code = tertiary_region_code;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("TargetRegionName"));
            t.add(new DefaultMutableTreeNode(new KVP("region_dept", this.region_dept, null)));
            t.add(new DefaultMutableTreeNode(new KVP("region_name_length", this.region_name_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("region_name", this.region_name, null)));
            t.add(new DefaultMutableTreeNode(new KVP("primary_region_code", this.primary_region_code, null)));
            if (this.region_dept >= 2) {
                t.add(new DefaultMutableTreeNode(new KVP("secondary_region_code", this.secondary_region_code, null)));
                if (this.region_dept == 3) {
                    t.add(new DefaultMutableTreeNode(new KVP("tertiary_region_code", this.tertiary_region_code, null)));
                }
            }
            return t;
        }
    }
}

