/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class TtmlSubtitlingDescriptor
extends DVBExtensionDescriptor {
    private final String iso639LanguageCode;
    private final int subtitle_purpose;
    private final int tts_suitability;
    private final int essential_font_usage_flag;
    private final int qualifier_present_flag;
    private final int reserved_zero_future_use;
    private final int dvb_ttml_profile_count;
    private final List<DvbTtmlProfile> profileList = new ArrayList<DvbTtmlProfile>();
    private long qualifier;
    private int font_count;
    private final List<Font> fontList = new ArrayList<Font>();
    private final DVBString text;
    private final LookUpList subtitle_purpose_list = new LookUpList.Builder().add(0, "same-lang-dialogue").add(1, "other-lang-dialogue").add(2, "all-dialogue").add(3, 15, "reserved for future use").add(16, "hard-of-hearing").add(17, "other-lang-dialoguewith-hard-of-hearing").add(18, "all-dialogue-with-hardof-hearing").add(19, 47, "reserved for future use").add(48, "audio-description").add(49, "content-relatedcommentary").add(50, 63, "reserved for future use ").build();
    private final LookUpList tts_suitability_list = new LookUpList.Builder().add(0, "unknown suitability for TTS").add(1, "suitable for TTS").add(2, "not suitable for TTS").add(3, "reserved for future use").build();

    public TtmlSubtitlingDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int i;
        int localOffset = 2;
        this.iso639LanguageCode = Utils.getISO8859_1String(b, localOffset, 3);
        this.subtitle_purpose = Utils.getInt(b, localOffset += 3, 1, 252) >> 2;
        this.tts_suitability = Utils.getInt(b, localOffset++, 1, 3);
        this.essential_font_usage_flag = Utils.getInt(b, localOffset, 1, 128) >> 7;
        this.qualifier_present_flag = Utils.getInt(b, localOffset, 1, 64) >> 6;
        this.reserved_zero_future_use = Utils.getInt(b, localOffset, 1, 48) >> 4;
        this.dvb_ttml_profile_count = Utils.getInt(b, localOffset++, 1, 15);
        for (i = 0; i < this.dvb_ttml_profile_count; ++i) {
            DvbTtmlProfile profile = new DvbTtmlProfile(Utils.getInt(b, localOffset++, 1, 255));
            this.profileList.add(profile);
        }
        if (this.qualifier_present_flag == 1) {
            this.qualifier = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
        }
        if (this.essential_font_usage_flag == 1) {
            this.font_count = Utils.getInt(b, localOffset++, 1, 255);
            for (i = 0; i < this.font_count; ++i) {
                int f = Utils.getInt(b, localOffset++, 1, 255);
                Font font = new Font(f);
                this.fontList.add(font);
            }
        }
        this.text = new DVBString(b, localOffset);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("iso639LanguageCode", this.iso639LanguageCode));
        t.add(new KVP("subtitle_purpose", this.subtitle_purpose).setDescription(this.subtitle_purpose_list.get(this.subtitle_purpose)));
        t.add(new KVP("TTS_suitability", this.tts_suitability).setDescription(this.tts_suitability_list.get(this.tts_suitability)));
        t.add(new KVP("essential_font_usage_flag", this.essential_font_usage_flag));
        t.add(new KVP("qualifier_present_flag", this.qualifier_present_flag));
        t.add(new KVP("reserved_zero_future_use", this.reserved_zero_future_use));
        t.add(new KVP("dvb_ttml_profile_count", this.dvb_ttml_profile_count));
        Utils.addListJTree(t, this.profileList, modus, "dvb_ttml_profile_list");
        if (this.qualifier_present_flag == 1) {
            t.add(new Qualifier(this.qualifier).getJTreeNode(modus));
        }
        if (this.essential_font_usage_flag == 1) {
            t.add(new KVP("font_count", this.font_count));
            Utils.addListJTree(t, this.fontList, modus, "font_list");
        }
        t.add(new KVP("text", this.text));
        return t;
    }

    public static class DvbTtmlProfile
    implements TreeNode {
        private final LookUpList dvb_ttml_profile_lookup_list = new LookUpList.Builder().add(0, "etd1\u2020|im1t").add(1, "im1t").add(2, "etd1").add(3, 255, "reserved for future use").build();
        private final int dvb_ttml_profile;

        public DvbTtmlProfile(int dvb_ttml_profile) {
            this.dvb_ttml_profile = dvb_ttml_profile;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            return new KVP("dvb_ttml_profile", this.dvb_ttml_profile).setDescription(this.dvb_ttml_profile_lookup_list.get(this.dvb_ttml_profile));
        }
    }

    public static class Font
    implements TreeNode {
        final int font_id;

        public Font(int font) {
            this.font_id = font & 0x7F;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            return new KVP("font_id", this.font_id);
        }
    }

    public static class Qualifier
    implements TreeNode {
        final LookUpList size_lookup_list = new LookUpList.Builder().add(0, "broadcaster's default size").add(1, "small").add(2, "medium").add(3, "large").add(4, 15, "reserved for future use").build();
        final LookUpList cadence_lookup_list = new LookUpList.Builder().add(0, "broadcaster's default cadence").add(1, "slow").add(2, "medium").add(3, "fast").add(4, 15, "reserved for future use").build();
        final LookUpList position_lookup_list = new LookUpList.Builder().add(0, "default").add(1, "top").add(2, "bottom").add(3, "speaker").add(4, "dynamic").add(5, 15, "reserved for future use").build();
        private final long qualifier;
        private final int size;
        private final int cadence;
        private final int monochrome_flag;
        private final int enhanced_accessibility_contrast_flag;
        private final int position;
        private final int reserved_zero_future_use;

        public Qualifier(long qualifier) {
            this.qualifier = qualifier;
            this.size = (int)((qualifier & 0xF0000000L) >> 28);
            this.cadence = (int)((qualifier & 0xF000000L) >> 24);
            this.monochrome_flag = (int)((qualifier & 0x800000L) >> 23);
            this.enhanced_accessibility_contrast_flag = (int)((qualifier & 0x400000L) >> 22);
            this.position = (int)((qualifier & 0x3B0000L) >> 18);
            this.reserved_zero_future_use = (int)((qualifier & 0x3FFFFL) >> 18);
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("qualifier", this.qualifier);
            t.add(new KVP("size", this.size).setDescription(this.size_lookup_list.get(this.size)));
            t.add(new KVP("cadence", this.cadence).setDescription(this.cadence_lookup_list.get(this.cadence)));
            t.add(new KVP("monochrome_flag", this.monochrome_flag));
            t.add(new KVP("enhanced_accessibility_contrast_flag", this.enhanced_accessibility_contrast_flag));
            t.add(new KVP("position", this.position).setDescription(this.position_lookup_list.get(this.position)));
            t.add(new KVP("reserved_zero_future_use", this.reserved_zero_future_use));
            return t;
        }
    }
}

