/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.MPEGExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class HEVCTimingAndHRDDescriptor
extends MPEGExtensionDescriptor {
    private final int hrd_management_valid_flag;
    private final int target_schedule_idx;
    private final int picture_and_timing_info_present;
    private int _90kHz_flag;
    private int reserved2;
    private long n;
    private long k;
    private long num_units_in_tick;
    private int target_schedule_idx_not_present_flag;

    public HEVCTimingAndHRDDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.hrd_management_valid_flag = Utils.getInt(b, 3, 1, 128) >>> 7;
        this.target_schedule_idx_not_present_flag = Utils.getInt(b, 3, 1, 64) >>> 6;
        this.target_schedule_idx = Utils.getInt(b, 3, 1, 62) >>> 1;
        this.picture_and_timing_info_present = Utils.getInt(b, 3, 1, 1);
        int t = 0;
        if (this.picture_and_timing_info_present == 1) {
            this._90kHz_flag = Utils.getInt(b, 4, 1, 128) >>> 7;
            this.reserved2 = Utils.getInt(b, 4, 1, 127);
            ++t;
            if (this._90kHz_flag == 0) {
                this.n = Utils.getLong(b, 5, 4, -1L);
                this.k = Utils.getLong(b, 9, 4, -1L);
                t += 8;
            }
            this.num_units_in_tick = Utils.getLong(b, 4 + t, 4, -1L);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("hrd_management_valid_flag", this.hrd_management_valid_flag).setDescription(this.getHrdManagmentDescription()));
        t.add(new KVP("target_schedule_idx_not_present_flag", this.target_schedule_idx_not_present_flag));
        t.add(new KVP("target_schedule_idx", this.target_schedule_idx));
        t.add(new KVP("picture_and_timing_info_present", this.picture_and_timing_info_present));
        if (this.picture_and_timing_info_present == 1) {
            t.add(new KVP("90kHz_flag", this._90kHz_flag));
            t.add(new KVP("reserved2", this.reserved2));
            if (this._90kHz_flag == 0) {
                t.add(new KVP("n", this.n));
                t.add(new KVP("k", this.k));
            }
            t.add(new KVP("num_units_in_tick", this.num_units_in_tick));
        }
        return t;
    }

    private String getHrdManagmentDescription() {
        return this.hrd_management_valid_flag == 1 ? "Buffering Period SEI and Picture Timing SEI messages shall be present in the associated HEVC video stream" : "leak method shall be used for the transfer from MBn to EBn";
    }
}

