/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.MPEGExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;

public class JpegXsVideoDescriptor
extends MPEGExtensionDescriptor {
    private final long descriptor_version;
    private final long horizontal_size;
    private final long vertical_size;
    private final long brat;
    private final long frat;
    private final long schar;
    private final long ppih;
    private final long plev;
    private final long max_buffer_size;
    private final long buffer_model_type;
    private final long colour_primaries;
    private final long transfer_characteristics;
    private final long matrix_coefficients;
    private final int video_full_range_flag;
    private final int still_mode;
    private final int mdm_flag;
    private final byte[] private_data;
    private final int zero_bits;
    private int x_c0;
    private int y_c0;
    private int x_c1;
    private int y_c1;
    private int x_c2;
    private int y_c2;
    private int x_wp;
    private int y_wp;
    private long l_max;
    private long l_min;
    private int maxcll;
    private int maxfall;

    public JpegXsVideoDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        BitSource reader = new BitSource(b, 3);
        this.descriptor_version = reader.readBitsLong(8);
        this.horizontal_size = reader.readBitsLong(16);
        this.vertical_size = reader.readBitsLong(16);
        this.brat = reader.readBitsLong(32);
        this.frat = reader.readBitsLong(32);
        this.schar = reader.readBitsLong(16);
        this.ppih = reader.readBitsLong(16);
        this.plev = reader.readBitsLong(16);
        this.max_buffer_size = reader.readBitsLong(32);
        this.buffer_model_type = reader.readBitsLong(8);
        this.colour_primaries = reader.readBitsLong(8);
        this.transfer_characteristics = reader.readBitsLong(8);
        this.matrix_coefficients = reader.readBitsLong(8);
        this.video_full_range_flag = reader.readBits(1);
        reader.skiptoByteBoundary();
        this.still_mode = reader.readBits(1);
        this.mdm_flag = reader.readBits(1);
        this.zero_bits = reader.readBits(6);
        if (this.mdm_flag == 1) {
            this.x_c0 = reader.readBits(16);
            this.y_c0 = reader.readBits(16);
            this.x_c1 = reader.readBits(16);
            this.y_c1 = reader.readBits(16);
            this.x_c2 = reader.readBits(16);
            this.y_c2 = reader.readBits(16);
            this.x_wp = reader.readBits(16);
            this.y_wp = reader.readBits(16);
            this.l_max = reader.readBitsLong(32);
            this.l_min = reader.readBitsLong(32);
            this.maxcll = reader.readBits(16);
            this.maxfall = reader.readBits(16);
        }
        reader.skiptoByteBoundary();
        this.private_data = reader.readBytes(reader.available() / 8);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("descriptor_version", this.descriptor_version));
        t.add(new KVP("horizontal_size", this.horizontal_size));
        t.add(new KVP("vertical_size", this.vertical_size));
        t.add(new KVP("brat", this.brat, "Bit Rate (MBits/s)"));
        t.add(JpegXsVideoDescriptor.buildFratNode(this.frat));
        t.add(JpegXsVideoDescriptor.buildScharNode(this.schar));
        t.add(JpegXsVideoDescriptor.buildPpihNode(this.ppih));
        t.add(JpegXsVideoDescriptor.buildPlevNode(this.plev));
        t.add(new KVP("max_buffer_size", this.max_buffer_size, "Maximum buffer size (Mbits/s)"));
        t.add(new KVP("buffer_model_type", this.buffer_model_type));
        t.add(new KVP("colour_primaries", this.colour_primaries));
        t.add(new KVP("transfer_characteristics", this.transfer_characteristics));
        t.add(new KVP("matrix_coefficients", this.matrix_coefficients));
        t.add(new KVP("video_full_range_flag", this.video_full_range_flag));
        t.add(new KVP("still_mode", this.still_mode));
        t.add(new KVP("mdm_flag", this.mdm_flag));
        t.add(new KVP("zero_bits", this.zero_bits));
        if (this.mdm_flag == 1) {
            t.add(new KVP("X_c0", this.x_c0));
            t.add(new KVP("Y_c0", this.y_c0));
            t.add(new KVP("X_c1", this.x_c1));
            t.add(new KVP("Y_c1", this.y_c1));
            t.add(new KVP("X_c2", this.x_c2));
            t.add(new KVP("Y_c2", this.y_c2));
            t.add(new KVP("X_wp", this.x_wp));
            t.add(new KVP("Y_wp", this.y_wp));
            t.add(new KVP("L_max", this.l_max));
            t.add(new KVP("L_min", this.l_min));
            t.add(new KVP("MaxCLL", this.maxcll));
            t.add(new KVP("MaxFALL", this.maxfall));
        }
        t.add(new KVP("private_data", this.private_data));
        return t;
    }

    public static KVP buildFratNode(long frat) {
        KVP fratNode = new KVP("frat", frat, "Frame rate");
        long interlaceMode = frat >> 30 & 3L;
        String interlaceText = interlaceMode == 0L ? "Progressive frame (frame contains one full-height picture)" : (interlaceMode == 1L ? "Interlaced frame (picture is first video field)" : (interlaceMode == 2L ? "Interlaced frame (picture is second video field)" : "Reserved"));
        fratNode.add(new KVP("interlace_mode", interlaceMode, interlaceText));
        long framerateDenominator = frat >> 24 & 0x3FL;
        String denominatorText = framerateDenominator == 1L ? "Value=1.000" : (framerateDenominator == 2L ? "Value=1.001" : "Reserved");
        fratNode.add(new KVP("framerate_denominator", framerateDenominator, denominatorText));
        long framerateNumerator = frat & 0xFFFFL;
        String numeratorText = "Frames/sec";
        fratNode.add(new KVP("framerate_numerator", framerateNumerator, "Frames/sec"));
        return fratNode;
    }

    public static KVP buildScharNode(long schar) {
        KVP scharNode = new KVP("schar", schar, "Sampling characteristics");
        long validFlag = schar >> 15 & 1L;
        String validText = validFlag == 0L ? "Invalid" : "Valid";
        scharNode.add(new KVP("valid_flag", validFlag, validText));
        long sampleBitDepth = schar >> 4 & 0xFL;
        scharNode.add(new KVP("sample_bitdepth", sampleBitDepth));
        long samplingStructure = schar & 0xFL;
        String samplingStructureText = JpegXsVideoDescriptor.samplingStructureToString(samplingStructure);
        scharNode.add(new KVP("sampling_structure", samplingStructure, samplingStructureText));
        return scharNode;
    }

    public static KVP buildPpihNode(long ppih) {
        return new KVP("ppih", ppih, JpegXsVideoDescriptor.ppihToString(ppih));
    }

    public static KVP buildPlevNode(long plev) {
        KVP plevNode = new KVP("plev", plev);
        long level = plev >> 8 & 0xFFL;
        String levelText = JpegXsVideoDescriptor.getLevelText(level);
        plevNode.add(new KVP("level", level, levelText));
        long subLevel = plev & 0xFFL;
        String subLevelText = JpegXsVideoDescriptor.getSubLevelText(subLevel);
        plevNode.add(new KVP("sub_level", subLevel, subLevelText));
        return plevNode;
    }

    private static String samplingStructureToString(long samplingStructure) {
        return switch ((int)samplingStructure) {
            case 0 -> "4:2:2 (YCbCr)";
            case 1 -> "4:4:4 (YCbCr)";
            case 2 -> "4:4:4 (RGB)";
            case 4 -> "4:2:2:4 (YCbCrAux)";
            case 5 -> "4:4:4:4 (YCbCrAux)";
            case 6 -> "4:4:4:4 (RGBAux)";
            default -> "Reserved";
        };
    }

    private static String ppihToString(long ppih) {
        return switch ((int)ppih) {
            case 0 -> "Unrestricted";
            case 5376 -> "Light 422.10";
            case 6656 -> "Light 444.12";
            case 9472 -> "Light-Subline 422.10";
            case 9536 -> "Main 422.10";
            case 14912 -> "Main 444.12";
            case 15936 -> "Main 4444.12";
            case 19008 -> "High 444.12";
            case 20032 -> "High 4444.12";
            default -> "Reserved";
        };
    }

    private static String getLevelText(long level) {
        return switch ((int)level) {
            case 0 -> "Unrestricted";
            case 16 -> "2k-1";
            case 32 -> "4k-1";
            case 36 -> "4k-2";
            case 40 -> "4k-3";
            case 48 -> "8k-1";
            case 52 -> "8k-2";
            case 56 -> "8k-3";
            case 64 -> "10k-1";
            default -> "Reserved";
        };
    }

    private static String getSubLevelText(long subLevel) {
        return switch ((int)subLevel) {
            case 0 -> "Unrestricted";
            case 128 -> "Full";
            case 16 -> "Sublev12bpp";
            case 12 -> "Sublev9bpp";
            case 8 -> "Sublev6bpp";
            case 4 -> "Sublev3bpp";
            default -> "Reserved";
        };
    }
}

