/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel.LogicalChannelInterface;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public abstract class AbstractLogicalChannelDescriptor
extends Descriptor
implements TableSource {
    public final DescriptorContext descriptorContext;
    protected final List<AbstractLogicalChannel> channelList = new ArrayList<AbstractLogicalChannel>();

    protected AbstractLogicalChannelDescriptor(byte[] b, int offset, TableSection parent, DescriptorContext descriptorContext) {
        super(b, offset, parent);
        this.descriptorContext = descriptorContext;
    }

    public String findServiceName(int service_id) {
        return this.getPSI().getSdt().getServiceName(this.descriptorContext.original_network_id, this.descriptorContext.transport_stream_id, service_id);
    }

    public String createNodeLabel(int service_id, int logical_channel_number) {
        String serviceName;
        if (this.descriptorContext.hasOnidTsid() && (serviceName = this.findServiceName(service_id)) != null) {
            return "logical_channel (" + serviceName + "): " + logical_channel_number;
        }
        return "logical_channel  " + logical_channel_number;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Object object = t.getUserObject();
        if (object instanceof KVP) {
            KVP kvp = (KVP)object;
            kvp.addTableSource(this, "logical_channels");
        }
        Utils.addListJTree(t, this.channelList, modus, "logical_channels", this);
        return t;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (LogicalChannelInterface logicalChannelInterface : this.channelList) {
            buf.append(logicalChannelInterface.toString());
        }
        return buf.toString();
    }

    public int getNoServices() {
        return this.channelList.size();
    }

    public List<AbstractLogicalChannel> getChannelList() {
        return this.channelList;
    }

    private static TableHeader<AbstractLogicalChannel, AbstractLogicalChannel> buildTableHeader() {
        return new TableHeaderBuilder().addRequiredRowColumn("service_id", AbstractLogicalChannel::getService_id, Integer.class).addRequiredRowColumn("logical_channel_number", AbstractLogicalChannel::getLogical_channel_number, Integer.class).addOptionalRowColumn("service name", AbstractLogicalChannel::getServiceName, String.class).build();
    }

    @Override
    public TableModel getTableModel() {
        FlexTableModel<AbstractLogicalChannel, AbstractLogicalChannel> tableModel = new FlexTableModel<AbstractLogicalChannel, AbstractLogicalChannel>(AbstractLogicalChannelDescriptor.buildTableHeader());
        for (AbstractLogicalChannel ch : this.channelList) {
            tableModel.addData(ch, List.of(ch));
        }
        tableModel.process();
        return tableModel;
    }

    public Integer getLCN(int serviceId) {
        for (AbstractLogicalChannel channel : this.getChannelList()) {
            if (channel.getService_id() != serviceId) continue;
            return channel.getLogical_channel_number();
        }
        return null;
    }

    public abstract class AbstractLogicalChannel
    implements LogicalChannelInterface {
        protected final int service_id;
        protected final int visible_service_flag;
        protected final int reserved;
        protected final int logical_channel_number;

        protected AbstractLogicalChannel(int service_id, int visible_service_flag, int reserved, int logical_channel_number) {
            this.service_id = service_id;
            this.visible_service_flag = visible_service_flag;
            this.reserved = reserved;
            this.logical_channel_number = logical_channel_number;
        }

        @Override
        public int getService_id() {
            return this.service_id;
        }

        @Override
        public int getVisible_service_flag() {
            return this.visible_service_flag;
        }

        @Override
        public int getReserved() {
            return this.reserved;
        }

        @Override
        public int getLogical_channel_number() {
            return this.logical_channel_number;
        }

        public String getServiceName() {
            return AbstractLogicalChannelDescriptor.this.findServiceName(this.service_id);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP(AbstractLogicalChannelDescriptor.this.createNodeLabel(this.service_id, this.logical_channel_number)));
            s.add(new DefaultMutableTreeNode(new KVP("service_id", this.service_id, null)));
            s.add(new DefaultMutableTreeNode(new KVP("visible_service_flag", this.visible_service_flag, null)));
            s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            s.add(new DefaultMutableTreeNode(new KVP("logical_channel_number", this.logical_channel_number, null)));
            return s;
        }
    }
}

