/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.avs;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AVS3VideoDescriptor
extends Descriptor {
    private final int profile_id;
    private final int level_id;
    private final int multiple_frame_rate_flag;
    private final int frame_rate_code;
    private final int sample_precision;
    private final int chroma_format;
    private final int temporal_id_flag;
    private final int td_mode_flag;
    private final int library_stream_flag;
    private final int library_picture_enable_flag;
    private final int colour_primaries;
    private final int transfer_characteristics;
    private final int matrix_coefficients;
    private static LookUpList frame_rate_Strings = new LookUpList.Builder(new String[]{"forbidden", "24/1.001", "24", "25", "30/1.001", "30", "50", "60/1.001", "60", "100", "120", "240", "400", "120/1.001", "unknown"}).build();
    private static LookUpList sample_precision_Strings = new LookUpList.Builder(new String[]{"forbidden", "8-bit", "10-bit"}).add(3, 7, "reserved").build();
    private static LookUpList chroma_format_Strings = new LookUpList.Builder(new String[]{"forbidden", "4:2:0", "4:2:2", "unknown"}).build();

    public AVS3VideoDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.profile_id = Utils.getInt(b, offset + 2, 1, 255);
        this.level_id = Utils.getInt(b, offset + 3, 1, 255);
        this.multiple_frame_rate_flag = Utils.getInt(b, offset + 4, 1, 128) >>> 7;
        this.frame_rate_code = Utils.getInt(b, offset + 4, 1, 127) >>> 3;
        this.sample_precision = Utils.getInt(b, offset + 4, 1, 7);
        this.chroma_format = Utils.getInt(b, offset + 5, 1, 192) >>> 6;
        this.temporal_id_flag = Utils.getInt(b, offset + 5, 1, 32) >>> 5;
        this.td_mode_flag = Utils.getInt(b, offset + 5, 1, 16) >>> 4;
        this.library_stream_flag = Utils.getInt(b, offset + 5, 1, 8) >>> 3;
        this.library_picture_enable_flag = Utils.getInt(b, offset + 5, 1, 4) >>> 2;
        this.colour_primaries = Utils.getInt(b, offset + 6, 1, 255);
        this.transfer_characteristics = Utils.getInt(b, offset + 7, 1, 255);
        this.matrix_coefficients = Utils.getInt(b, offset + 8, 1, 255);
    }

    private static final String profile_id_String(int profile_id) {
        return switch (profile_id) {
            case 32 -> "Main 8-bit Profile";
            case 34 -> "Main 10-bit Profile";
            case 48 -> "High 8-bit Profile";
            case 50 -> "High 10-bit Profile";
            default -> throw new IllegalArgumentException("Invalid value in profile_id_String:" + profile_id);
        };
    }

    private static final String level_id_String(int level_id) {
        return switch (level_id) {
            case 16 -> "2.0.15";
            case 18 -> "2.0.30";
            case 20 -> "2.0.60";
            case 32 -> "4.0.30";
            case 34 -> "4.0.60";
            case 64 -> "6.0.30";
            case 66 -> "6.2.30";
            case 65 -> "6.4.30";
            case 67 -> "6.6.30";
            case 68 -> "6.0.60";
            case 70 -> "6.2.60";
            case 69 -> "6.4.60";
            case 71 -> "6.6.60";
            case 72 -> "6.0.120";
            case 74 -> "6.2.120";
            case 73 -> "6.4.120";
            case 75 -> "6.6.120";
            case 80 -> "8.0.30";
            case 82 -> "8.2.30";
            case 81 -> "8.4.30";
            case 83 -> "8.6.30";
            case 84 -> "8.0.60";
            case 86 -> "8.2.60";
            case 85 -> "8.4.60";
            case 87 -> "8.6.60";
            case 88 -> "8.0.120";
            case 90 -> "8.2.120";
            case 89 -> "8.4.120";
            case 91 -> "8.6.120";
            case 96 -> "10.0.30";
            case 98 -> "10.2.30";
            case 97 -> "10.4.30";
            case 99 -> "10.6.30";
            case 100 -> "10.0.60";
            case 102 -> "10.2.60";
            case 101 -> "10.4.60";
            case 103 -> "10.6.60";
            case 104 -> "10.0.120";
            case 106 -> "10.2.120";
            case 105 -> "10.4.120";
            case 107 -> "10.6.120";
            default -> throw new IllegalArgumentException("Invalid value in level_id_String:" + level_id);
        };
    }

    private static final String frame_rate_code_String(int frame_rate_code) {
        String res = frame_rate_Strings.get(frame_rate_code);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Invalid value in frame_rate_code_String:" + frame_rate_code);
    }

    private static final String sample_precision_String(int sample_precision) {
        String res = sample_precision_Strings.get(sample_precision);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Invalid value in sample_precision_String:" + sample_precision);
    }

    private static final String chroma_format_String(int chroma_format) {
        String res = chroma_format_Strings.get(chroma_format);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Invalid value in chroma_format_String:" + chroma_format);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("profile_id", this.profile_id, AVS3VideoDescriptor.profile_id_String(this.profile_id))));
        t.add(new DefaultMutableTreeNode(new KVP("level_id", this.level_id, AVS3VideoDescriptor.level_id_String(this.level_id))));
        t.add(new DefaultMutableTreeNode(new KVP("multiple_frame_rate_flag", this.multiple_frame_rate_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_code", this.frame_rate_code, AVS3VideoDescriptor.frame_rate_code_String(this.frame_rate_code))));
        t.add(new DefaultMutableTreeNode(new KVP("sample_precision", this.sample_precision, AVS3VideoDescriptor.sample_precision_String(this.sample_precision))));
        t.add(new DefaultMutableTreeNode(new KVP("chroma_format", this.chroma_format, AVS3VideoDescriptor.chroma_format_String(this.chroma_format))));
        t.add(new DefaultMutableTreeNode(new KVP("temporal_id_flag", this.temporal_id_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("td_mode_flag", this.td_mode_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("library_stream_flag", this.library_stream_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("library_picture_enable_flag", this.library_picture_enable_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("colour_primaries", this.colour_primaries, null)));
        t.add(new DefaultMutableTreeNode(new KVP("transfer_characteristics", this.transfer_characteristics, null)));
        t.add(new DefaultMutableTreeNode(new KVP("matrix_coefficients", this.matrix_coefficients, null)));
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "AVS3 Video Descriptor";
    }
}

