/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel.AbstractLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CosLogicalChannelDescriptor
extends AbstractLogicalChannelDescriptor {
    public CosLogicalChannelDescriptor(byte[] b, int offset, TableSection parent, DescriptorContext descriptorContext) {
        super(b, offset, parent, descriptorContext);
        for (int t = 0; t < this.descriptorLength; t += 4) {
            int serviceId = Utils.getInt(b, offset + 2 + t, 2, 65535);
            int visible = Utils.getInt(b, offset + t + 4, 1, 128) >> 7;
            int free_access = Utils.getInt(b, offset + t + 4, 1, 64) >> 6;
            int reserved = Utils.getInt(b, offset + t + 4, 1, 60) >> 2;
            int chNumber = Utils.getInt(b, offset + t + 4, 2, 1023);
            this.channelList.add(new CosLogicalChannel(serviceId, visible, free_access, reserved, chNumber));
        }
    }

    @Override
    public String getDescriptorname() {
        return "cos_logical_channel_descriptor";
    }

    public class CosLogicalChannel
    extends AbstractLogicalChannelDescriptor.AbstractLogicalChannel {
        int free_access_flag;

        CosLogicalChannel(int service_id, int visible_service_flag, int free_access_flag, int reserved, int logical_channel_number) {
            super(service_id, visible_service_flag, reserved, logical_channel_number);
            this.free_access_flag = free_access_flag;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP(CosLogicalChannelDescriptor.this.createNodeLabel(this.service_id, this.logical_channel_number)));
            s.add(new DefaultMutableTreeNode(new KVP("service_id", this.service_id, null)));
            s.add(new DefaultMutableTreeNode(new KVP("visible_service_flag", this.visible_service_flag, null)));
            s.add(new DefaultMutableTreeNode(new KVP("free_access_flag", this.free_access_flag, null)));
            s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            s.add(new DefaultMutableTreeNode(new KVP("logical_channel_number", this.logical_channel_number, null)));
            return s;
        }
    }
}

