/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.canal_international;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CosTimezoneDescriptor
extends Descriptor {
    private List<TimezoneName> timezoneNames = new ArrayList<TimezoneName>();

    public CosTimezoneDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        DVBString regionName;
        for (int t = 0; t < this.descriptorLength; t += 5 + regionName.getLength()) {
            String countryCode = Utils.getISO8859_1String(b, offset + 2 + t, 3);
            int countryRegionId = Utils.getInt(b, offset + t + 5, 1, 252) >> 2;
            int reserved = Utils.getInt(b, offset + t + 5, 1, 3);
            regionName = new DVBString(b, offset + t + 6);
            TimezoneName timezoneName = new TimezoneName(countryCode, countryRegionId, reserved, regionName);
            this.timezoneNames.add(timezoneName);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.timezoneNames, modus, "Timezone Names");
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "cos_timezone_descriptor";
    }

    public record TimezoneName(String country_code, int country_region_id, int reserved, DVBString region_name) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("TimezoneName");
            s.add(new KVP("country_code", this.country_code));
            s.add(new KVP("country_region_id", this.country_region_id));
            s.add(new KVP("reserved", this.reserved, null));
            s.add(new KVP("region_name", this.region_name));
            return s;
        }
    }
}

