/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.casema;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitString;
import nl.digitalekabeltelevisie.util.Utils;

public class ZiggoPackageDescriptor
extends Descriptor {
    private final byte[] packages;
    private static String[] packageNames = new String[]{"TV Standard", "package 1", "package 2", "package 3", "Turks", "Hindi", "package 6", "Eredivisie Live", "Film 1", "Sport 1", "Chinees", "Uitgebreid Turks", "Gay Lifestyle", "package 13", "package 14", "package 15", "Erotiek", "TV Plus", "TV Extra", "package 19", "package 20", "package 21", "package 22", "package 23", "package 24", "package 25", "package 26", "package 27", "package 28", "package 29", "package 30", "package 31"};

    public ZiggoPackageDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.packages = Utils.copyOfRange(b, offset + 2, offset + 2 + this.getDescriptorLength());
    }

    @Override
    public String getDescriptorname() {
        return "Ziggo Package Descriptor";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("packages", this.packages, ZiggoPackageDescriptor.getPackagesList(this.packages))));
        return t;
    }

    private static String getPackagesList(byte[] packages) {
        StringBuilder t = new StringBuilder();
        BitString bs = new BitString(packages);
        for (int i = 0; i < packageNames.length; ++i) {
            int bit = bs.getIntBitsEnd(1);
            if (bit != 1) continue;
            t.append(packageNames[i]).append(',');
        }
        if (t.length() > 0) {
            t.delete(t.length() - 1, t.length());
        }
        return t.toString();
    }

    public byte[] getPackages() {
        return this.packages;
    }
}

