/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.dtg;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class GuidanceDescriptor
extends Descriptor {
    int reserved;
    int guidance_type;
    String iso_639_language_code;
    DVBString guidance_char;
    int guidance_mode;
    int reserved2;
    byte[] reserved_for_future_use;

    public GuidanceDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.reserved = Utils.getInt(b, 2, 1, 252) >> 2;
        this.guidance_type = Utils.getInt(b, 2, 1, 3);
        if (this.guidance_type == 0) {
            this.iso_639_language_code = Utils.getISO8859_1String(b, 3, 3);
            this.guidance_char = new DVBString(b, 6, this.descriptorLength - 4);
        } else if (this.guidance_type == 1) {
            this.reserved2 = Utils.getInt(b, 3, 1, 254) >> 1;
            this.guidance_mode = Utils.getInt(b, 3, 1, 1);
            this.iso_639_language_code = Utils.getISO8859_1String(b, 4, 3);
            this.guidance_char = new DVBString(b, 7, this.descriptorLength - 5);
        } else {
            this.reserved_for_future_use = Utils.getBytes(b, 3, this.descriptorLength - 3);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("reserved", this.reserved));
        t.add(new KVP("guidance_type", this.guidance_type));
        if (this.guidance_type == 0) {
            t.add(new KVP("ISO_639_language_code", this.iso_639_language_code));
            t.add(new KVP("guidance_char", this.guidance_char));
        } else if (this.guidance_type == 1) {
            t.add(new KVP("reserved", this.reserved2));
            t.add(new KVP("guidance_mode", this.guidance_mode).setDescription(this.guidance_mode == 1 ? "guidance for content unsuitable for broadcast until after the watershed is appropriate." : null));
            t.add(new KVP("ISO_639_language_code", this.iso_639_language_code));
            t.add(new KVP("guidance_char", this.guidance_char));
        } else {
            t.add(new KVP("reserved_for_future_use", this.reserved_for_future_use));
        }
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "DTG guidance_descriptor";
    }
}

