/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class M7LogicalChannelDescriptor
extends M7Descriptor {
    private final List<LogicalChannel> channelList = new ArrayList<LogicalChannel>();

    public M7LogicalChannelDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        for (int t = 0; t < this.descriptorLength; t += 4) {
            int serviceId = Utils.getInt(b, 2 + t, 2, 65535);
            int reserved = Utils.getInt(b, t + 4, 1, 128) >> 7;
            int hidden = Utils.getInt(b, t + 4, 1, 64) >> 6;
            int chNumber = Utils.getInt(b, t + 4, 2, 16383);
            LogicalChannel s = new LogicalChannel(serviceId, reserved, hidden, chNumber);
            this.channelList.add(s);
        }
    }

    public int getNoServices() {
        return this.channelList.size();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (int i = 0; i < this.getNoServices(); ++i) {
            LogicalChannel s = this.channelList.get(i);
            buf.append("(").append(i).append(";").append(s.serviceID()).append(":").append(s.logicalChannelNumber()).append(":").append(s.getVisibleServiceFlag()).append("),");
        }
        return buf.toString();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.addList(this.channelList, modus, "logical_channels");
        return t;
    }

    public List<LogicalChannel> getChannelList() {
        return this.channelList;
    }

    public record LogicalChannel(int serviceID, int reserved, int hidden, int logicalChannelNumber) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("logical_channel: " + this.logicalChannelNumber);
            s.add(new KVP("service_id", this.serviceID));
            s.add(new KVP("reserved", this.reserved));
            s.add(new KVP("hidden", this.hidden));
            s.add(new KVP("logical_channel_number", this.logicalChannelNumber));
            return s;
        }

        public int getVisibleServiceFlag() {
            return this.reserved;
        }
    }
}

