/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class M7OperatorDiSEqCTDescriptor
extends M7Descriptor {
    private List<DiSEqC> diSEqCList = new ArrayList<DiSEqC>();

    public M7OperatorDiSEqCTDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.diSEqCList = this.buildDiSEqCList(b, 2, this.descriptorLength);
    }

    private List<DiSEqC> buildDiSEqCList(byte[] data, int offset, int diseqc_loop_length) {
        ArrayList<DiSEqC> r = new ArrayList<DiSEqC>();
        for (int t = 0; t < diseqc_loop_length; t += 3) {
            String orbitalPosition = Utils.getBCD(data, (offset + t) * 2, 4);
            int westEastFlag = Utils.getInt(data, offset + t + 2, 1, 128) >>> 7;
            int reserved = Utils.getInt(data, offset + t + 2, 1, 127);
            DiSEqC diseqc = new DiSEqC(orbitalPosition, westEastFlag, reserved);
            r.add(diseqc);
        }
        return r;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.addList(this.diSEqCList, modus, "DiSEqC_loop");
        return t;
    }

    public List<DiSEqC> getDiSEqCList() {
        return this.diSEqCList;
    }

    public record DiSEqC(String orbital_position, int westEastFlag, int reserved) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("DiSEqC");
            t.add(new KVP("orbital_position", this.orbital_position, Descriptor.formatOrbitualPosition(this.orbital_position)));
            t.add(new KVP("west_east_flag", this.westEastFlag, this.getWestEastString()));
            t.add(new KVP("reserved", this.reserved));
            return t;
        }

        public String getTotalPositionString() {
            return Descriptor.formatOrbitualPosition(this.orbital_position) + " " + this.getWestEastString();
        }

        public String getWestEastString() {
            return this.westEastFlag == 1 ? "east" : "west";
        }
    }
}

