/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.nordig;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.logicalchannel.AbstractLogicalChannelDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class NordigLogicalChannelDescriptorV2
extends AbstractLogicalChannelDescriptor {
    private List<ChannelList> channelLists = new ArrayList<ChannelList>();

    public NordigLogicalChannelDescriptorV2(byte[] b, TableSection parent, DescriptorContext descriptorContext) {
        super(b, 0, parent, descriptorContext);
        int s;
        for (int t = 0; t < this.descriptorLength; t += s) {
            int channel_list_id = Utils.getInt(b, 2 + t, 1, 255);
            DVBString channel_list_name = new DVBString(b, t + 3);
            String country_code = Utils.getISO8859_1String(b, (t += 2 + channel_list_name.getLength()) + 2, 3);
            int service_loop_length = Utils.getInt(b, 2 + (t += 3), 1, 255);
            ++t;
            ArrayList<LogicalChannel> channelList = new ArrayList<LogicalChannel>();
            for (s = 0; s < service_loop_length; s += 4) {
                int serviceId = Utils.getInt(b, 2 + t + s, 2, 65535);
                int visible = Utils.getInt(b, t + 4 + s, 1, 128) >> 7;
                int reserved = Utils.getInt(b, t + 4 + s, 1, 124) >> 2;
                int chNumber = Utils.getInt(b, t + 4 + s, 2, 1023);
                LogicalChannel lc = new LogicalChannel(this, serviceId, visible, reserved, chNumber);
                channelList.add(lc);
            }
            ChannelList chList = new ChannelList(channel_list_id, channel_list_name, country_code, service_loop_length, channelList);
            this.channelLists.add(chList);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.channelLists, modus, "Channel Lists");
        return t;
    }

    @Override
    public String getDescriptorname() {
        return "Nordig Logical Channel Descriptor V2";
    }

    public class LogicalChannel
    extends AbstractLogicalChannelDescriptor.AbstractLogicalChannel {
        public LogicalChannel(NordigLogicalChannelDescriptorV2 this$0, int service_id, int visible_service, int reserved, int logical_channel_number) {
            super(service_id, visible_service, reserved, logical_channel_number);
        }
    }

    public record ChannelList(int channel_list_id, DVBString channel_list_name, String country_code, int service_loop_length, List<LogicalChannel> logicalChannelList) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Channel List (" + String.valueOf(this.channel_list_name) + ")");
            s.add(new KVP("channel_list_id", this.channel_list_id));
            s.add(new KVP("channel_list_name", this.channel_list_name));
            s.add(new KVP("country_code", this.country_code));
            s.add(new KVP("service_loop_length", this.service_loop_length));
            Utils.addListJTree(s, this.logicalChannelList, modus, "Logical Channels");
            return s;
        }
    }
}

