/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MessageDescriptor
extends UNTDescriptor {
    private final int descriptorNumber;
    private final int lastDescriptorNumber;
    private final String iso639LanguageCode;
    private final DVBString text;

    public MessageDescriptor(byte[] b, TableSection parent) {
        super(b, 0, parent);
        this.descriptorNumber = Utils.getInt(b, 2, 1, 240) >> 4;
        this.lastDescriptorNumber = Utils.getInt(b, 2, 1, 15);
        this.iso639LanguageCode = Utils.getISO8859_1String(b, 3, 3);
        this.text = new DVBString(b, 6, this.descriptorLength - 4);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("descriptor_number", this.descriptorNumber));
        t.add(new KVP("last_descriptor_number", this.lastDescriptorNumber));
        t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
        t.add(new KVP("platform name", this.text));
        return t;
    }

    public int getDescriptorNumber() {
        return this.descriptorNumber;
    }

    public String getIso639LanguageCode() {
        return this.iso639LanguageCode;
    }

    public int getLastDescriptorNumber() {
        return this.lastDescriptorNumber;
    }

    public DVBString getText() {
        return this.text;
    }
}

